/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.storage;

import com.portable.storage.player.PlayerStorageAccess;
import com.portable.storage.storage.StorageType;
import com.portable.storage.storage.UnifiedUpgradeManager;
import com.portable.storage.storage.UpgradeSlotType;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_3222;

public class UpgradeInventory {
    private static final int BASE_SLOT_COUNT = 5;
    private static final int EXTENDED_SLOT_COUNT = 5;
    private static final int TOTAL_SLOT_COUNT = 10;
    private final UnifiedUpgradeManager upgradeManager = new UnifiedUpgradeManager();

    public int getSlotCount() {
        return 10;
    }

    public int getBaseSlotCount() {
        return 5;
    }

    public int getExtendedSlotCount() {
        return 5;
    }

    public class_1799 getStack(int slot) {
        if (slot < 0 || slot >= 10) {
            return class_1799.field_8037;
        }
        if (slot < 5) {
            return this.upgradeManager.getBaseSlot(slot);
        }
        int extendedSlot = slot - 5;
        return this.upgradeManager.getExtendedSlot(extendedSlot);
    }

    public class_1799 getFluidStack() {
        return this.upgradeManager.getFluidSlot();
    }

    public void setFluidStack(class_1799 stack) {
        this.upgradeManager.setFluidSlot(stack);
    }

    public int getFluidUnits(String fluidType) {
        return this.upgradeManager.getFluidUnits(fluidType);
    }

    public void setFluidUnits(String fluidType, int units) {
        this.upgradeManager.setFluidUnits(fluidType, units);
    }

    public void addFluidUnits(String fluidType, int units) {
        this.upgradeManager.addFluidUnits(fluidType, units);
    }

    public boolean removeFluidUnits(String fluidType, int units) {
        return this.upgradeManager.removeFluidUnits(fluidType, units);
    }

    public void setStack(int slot, class_1799 stack) {
        if (slot < 0 || slot >= 10) {
            return;
        }
        if (slot < 5) {
            this.upgradeManager.setBaseSlot(slot, stack);
        } else {
            int extendedSlot = slot - 5;
            this.upgradeManager.setExtendedSlot(extendedSlot, stack);
        }
    }

    public static boolean isValidUpgradeForSlot(int slot, class_1799 stack) {
        if (stack.method_7960() || slot < 0) {
            return false;
        }
        if (slot < 5) {
            UpgradeSlotType slotType = UpgradeSlotType.getBaseSlotType(slot);
            return slotType != null && slotType.isValidItem(stack);
        }
        if (slot < 10) {
            int extendedSlot = slot - 5;
            UpgradeSlotType slotType = UpgradeSlotType.getExtendedSlotType(extendedSlot);
            return slotType != null && slotType.isValidItem(stack);
        }
        return false;
    }

    public static boolean isValidFluidItem(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        return stack.method_31574(class_1802.field_8187) || stack.method_31574(class_1802.field_8705) || stack.method_31574(class_1802.field_8103) || stack.method_31574(class_1802.field_8550);
    }

    public static String getFluidType(class_1799 stack) {
        if (stack.method_31574(class_1802.field_8187)) {
            return "lava";
        }
        if (stack.method_31574(class_1802.field_8705)) {
            return "water";
        }
        if (stack.method_31574(class_1802.field_8103)) {
            return "milk";
        }
        return null;
    }

    public static class_1799 createFluidBucket(String fluidType) {
        return switch (fluidType) {
            case "lava" -> new class_1799((class_1935)class_1802.field_8187);
            case "water" -> new class_1799((class_1935)class_1802.field_8705);
            case "milk" -> new class_1799((class_1935)class_1802.field_8103);
            default -> class_1799.field_8037;
        };
    }

    public static class_1799 getExpectedUpgradeForSlot(int slot) {
        if (slot < 0) {
            return class_1799.field_8037;
        }
        if (slot < 5) {
            UpgradeSlotType slotType = UpgradeSlotType.getBaseSlotType(slot);
            return slotType != null ? slotType.getExpectedStack() : class_1799.field_8037;
        }
        if (slot < 10) {
            int extendedSlot = slot - 5;
            UpgradeSlotType slotType = UpgradeSlotType.getExtendedSlotType(extendedSlot);
            return slotType != null ? slotType.getExpectedStack() : class_1799.field_8037;
        }
        return class_1799.field_8037;
    }

    public static class_1799 getExpectedFluidForSlot() {
        return new class_1799((class_1935)class_1802.field_8550);
    }

    public boolean isSlotDisabled(int slot, class_3222 player) {
        PlayerStorageAccess access;
        if (slot < 0 || slot >= 10) {
            return false;
        }
        if (UpgradeInventory.isPrimaryStorageRestrictedSlot(slot) && (access = (PlayerStorageAccess)player).portableStorage$getStorageType() == StorageType.PRIMARY) {
            return true;
        }
        if (slot < 5) {
            return this.upgradeManager.isBaseSlotDisabled(slot);
        }
        int extendedSlot = slot - 5;
        return this.upgradeManager.isExtendedSlotDisabled(extendedSlot);
    }

    public void setSlotDisabled(int slot, boolean disabled) {
        if (slot < 0 || slot >= 10) {
            return;
        }
        if (slot < 5) {
            this.upgradeManager.setBaseSlotDisabled(slot, disabled);
        } else {
            int extendedSlot = slot - 5;
            this.upgradeManager.setExtendedSlotDisabled(extendedSlot, disabled);
        }
    }

    public void toggleSlotDisabled(int slot) {
        if (slot < 0 || slot >= 10) {
            return;
        }
        if (slot < 5) {
            this.upgradeManager.toggleBaseSlotDisabled(slot);
        } else {
            int extendedSlot = slot - 5;
            this.upgradeManager.toggleExtendedSlotDisabled(extendedSlot);
        }
    }

    public static boolean isExtendedSlot(int slot) {
        return slot >= 5 && slot < 10;
    }

    public static boolean isPrimaryStorageRestrictedSlot(int slot) {
        return slot == 3 || slot == 4 || slot == 5 || slot == 8 || slot == 9;
    }

    public static boolean isPlayerUsingPrimaryStorage(class_3222 player) {
        if (player == null) {
            return false;
        }
        PlayerStorageAccess access = (PlayerStorageAccess)player;
        return access.portableStorage$getStorageType() == StorageType.PRIMARY;
    }

    public boolean isChestUpgradeActive() {
        return this.upgradeManager.isChestUpgradeActive();
    }

    public boolean isSpectralArrowUpgradeActive() {
        return this.upgradeManager.isSpectralArrowUpgradeActive();
    }

    public boolean isBedUpgradeActive() {
        return this.upgradeManager.isBedUpgradeActive();
    }

    public boolean isXpBottleUpgradeActive() {
        return this.upgradeManager.isXpBottleUpgradeActive();
    }

    public boolean isPistonUpgradeActive() {
        return this.upgradeManager.isPistonUpgradeActive();
    }

    public boolean isEnchantedGoldenAppleUpgradeActive() {
        return this.upgradeManager.isEnchantedGoldenAppleUpgradeActive();
    }

    public boolean isTrashSlotActive() {
        return this.upgradeManager.isTrashSlotActive();
    }

    public boolean isExtendedSlotEnabled(int slot) {
        if (!UpgradeInventory.isExtendedSlot(slot)) {
            return false;
        }
        int extendedSlot = slot - 5;
        return this.upgradeManager.isExtendedSlotEnabled(extendedSlot);
    }

    public boolean tryInsert(int slot, class_1799 stack, class_3222 player, UUID playerUuid, String playerName) {
        if (slot < 0 || slot >= 10) {
            return false;
        }
        if (UpgradeInventory.isPrimaryStorageRestrictedSlot(slot)) {
            if (player != null) {
                PlayerStorageAccess access = (PlayerStorageAccess)player;
                if (access.portableStorage$getStorageType() == StorageType.PRIMARY) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (slot < 5) {
            if (player != null) {
                return this.upgradeManager.tryInsertBaseSlot(slot, stack, player.method_5667(), player.method_5477().getString());
            }
            return this.upgradeManager.tryInsertBaseSlot(slot, stack, playerUuid, playerName);
        }
        int extendedSlot = slot - 5;
        return this.upgradeManager.tryInsertExtendedSlot(extendedSlot, stack);
    }

    public class_1799 takeStack(int slot) {
        if (slot < 0 || slot >= 10) {
            return class_1799.field_8037;
        }
        if (slot < 5) {
            return this.upgradeManager.takeBaseSlot(slot);
        }
        int extendedSlot = slot - 5;
        return this.upgradeManager.takeExtendedSlot(extendedSlot);
    }

    public boolean hasUpgrade(class_1799 upgradeType) {
        class_1799 slot;
        int i;
        for (i = 0; i < 5; ++i) {
            slot = this.upgradeManager.getBaseSlot(i);
            if (!class_1799.method_7984((class_1799)slot, (class_1799)upgradeType)) continue;
            return true;
        }
        for (i = 0; i < 5; ++i) {
            slot = this.upgradeManager.getExtendedSlot(i);
            if (!class_1799.method_7984((class_1799)slot, (class_1799)upgradeType)) continue;
            return true;
        }
        return false;
    }

    public void writeNbt(class_2487 nbt) {
        this.upgradeManager.writeNbt(nbt);
    }

    public void readNbt(class_2487 nbt) {
        this.upgradeManager.readNbt(nbt);
    }

    public List<class_1799> getExtendedSlotItems() {
        return this.upgradeManager.getExtendedSlotItems();
    }

    public void clearExtendedSlots() {
        this.upgradeManager.clearExtendedSlots();
    }

    public long getXpPool() {
        return this.upgradeManager.getXpPool();
    }

    public long addToXpPool(long amount) {
        return this.upgradeManager.addToXpPool(amount);
    }

    public long removeFromXpPool(long amount) {
        return this.upgradeManager.removeFromXpPool(amount);
    }

    public boolean isLevelMaintenanceEnabled() {
        return this.upgradeManager.isLevelMaintenanceEnabled();
    }

    public void setLevelMaintenanceEnabled(boolean enabled) {
        this.upgradeManager.setLevelMaintenanceEnabled(enabled);
    }

    public void toggleLevelMaintenance() {
        this.upgradeManager.toggleLevelMaintenance();
    }

    public class_1799 getTrashSlot() {
        return this.upgradeManager.getTrashSlot();
    }

    public void setTrashSlot(class_1799 stack) {
        this.upgradeManager.setTrashSlot(stack);
    }

    public boolean isTrashSlotDisabled() {
        return this.upgradeManager.isTrashSlotDisabled();
    }

    public void setTrashSlotDisabled(boolean disabled) {
        this.upgradeManager.setTrashSlotDisabled(disabled);
    }

    public void toggleTrashSlotDisabled() {
        this.upgradeManager.toggleTrashSlotDisabled();
    }

    public boolean tryInsertTrashSlot(class_1799 stack) {
        return this.upgradeManager.tryInsertTrashSlot(stack);
    }

    public class_1799 takeTrashSlot() {
        return this.upgradeManager.takeTrashSlot();
    }
}

