/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.storage;

import com.portable.storage.PortableStorage;
import com.portable.storage.config.ServerConfig;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public enum UpgradeSlotType {
    CRAFTING_TABLE(0, class_1802.field_8465, "crafting_table"),
    HOPPER(1, class_1802.field_8239, "hopper"),
    CHEST(2, class_1802.field_8106, "chest"),
    BARREL(3, class_1802.field_16307, "barrel"),
    DRAGON_EGG(4, class_1802.field_8840, "dragon_egg"),
    SPECTRAL_ARROW(0, class_1802.field_8236, "spectral_arrow", true),
    BED(1, class_1802.field_8789, "bed", true),
    EXPERIENCE_BOTTLE(2, class_1802.field_8287, "experience_bottle", true),
    PISTON(3, class_1802.field_8249, "piston", true),
    ENCHANTED_GOLDEN_APPLE(4, class_1802.field_8367, "enchanted_golden_apple", true);

    private final int slotIndex;
    private final class_1792 expectedItem;
    private final String translationKey;
    private final boolean isExtended;

    private UpgradeSlotType(int slotIndex, class_1792 expectedItem, String translationKey) {
        this(slotIndex, expectedItem, translationKey, false);
    }

    private UpgradeSlotType(int slotIndex, class_1792 expectedItem, String translationKey, boolean isExtended) {
        this.slotIndex = slotIndex;
        this.expectedItem = expectedItem;
        this.translationKey = translationKey;
        this.isExtended = isExtended;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }

    public class_1792 getExpectedItem() {
        return this.expectedItem;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public class_1799 getExpectedStack() {
        if (this == DRAGON_EGG) {
            return new class_1799((class_1935)UpgradeSlotType.getRiftUpgradeItem());
        }
        return new class_1799((class_1935)this.expectedItem);
    }

    public static UpgradeSlotType getBaseSlotType(int slotIndex) {
        for (UpgradeSlotType type : UpgradeSlotType.values()) {
            if (type.isExtended || type.slotIndex != slotIndex) continue;
            return type;
        }
        return null;
    }

    public static UpgradeSlotType getExtendedSlotType(int slotIndex) {
        for (UpgradeSlotType type : UpgradeSlotType.values()) {
            if (!type.isExtended || type.slotIndex != slotIndex) continue;
            return type;
        }
        return null;
    }

    private static class_1792 getRiftUpgradeItem() {
        String configValue = ServerConfig.getInstance().getRiftUpgradeItem();
        try {
            String[] parts = configValue.split(":", 3);
            if (parts.length == 3) {
                String namespace = parts[1];
                String path = parts[2];
                class_2960 id = class_2960.method_60655((String)namespace, (String)path);
                return (class_1792)class_7923.field_41178.method_10223(id);
            }
            class_2960 id = class_2960.method_12829((String)configValue);
            return (class_1792)class_7923.field_41178.method_10223(id);
        }
        catch (Exception e) {
            PortableStorage.LOGGER.warn("Failed to parse rift upgrade item: {}", (Object)configValue, (Object)e);
            return class_1802.field_8840;
        }
    }

    public boolean isValidItem(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        if (this == BED) {
            return stack.method_31574(class_1802.field_8789) || stack.method_31574(class_1802.field_8112) || stack.method_31574(class_1802.field_8893) || stack.method_31574(class_1802.field_8464) || stack.method_31574(class_1802.field_8390) || stack.method_31574(class_1802.field_8754) || stack.method_31574(class_1802.field_8368) || stack.method_31574(class_1802.field_8286) || stack.method_31574(class_1802.field_8146) || stack.method_31574(class_1802.field_8679) || stack.method_31574(class_1802.field_8349) || stack.method_31574(class_1802.field_8059) || stack.method_31574(class_1802.field_8417) || stack.method_31574(class_1802.field_8262) || stack.method_31574(class_1802.field_8258) || stack.method_31574(class_1802.field_8863);
        }
        if (this == DRAGON_EGG) {
            return stack.method_31574(UpgradeSlotType.getRiftUpgradeItem());
        }
        return stack.method_31574(this.expectedItem);
    }
}

