/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.sync;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class PlayerViewState {
    private static final Set<UUID> VIEWING_PLAYERS = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> PENDING_SYNC_PLAYERS = ConcurrentHashMap.newKeySet();

    public static void startViewing(UUID playerId) {
        VIEWING_PLAYERS.add(playerId);
        PENDING_SYNC_PLAYERS.remove(playerId);
    }

    public static void stopViewing(UUID playerId) {
        VIEWING_PLAYERS.remove(playerId);
    }

    public static boolean isViewing(UUID playerId) {
        return VIEWING_PLAYERS.contains(playerId);
    }

    public static void markPendingSync(UUID playerId) {
        if (!PlayerViewState.isViewing(playerId)) {
            PENDING_SYNC_PLAYERS.add(playerId);
        }
    }

    public static Set<UUID> getPendingSyncPlayers() {
        return Set.copyOf(PENDING_SYNC_PLAYERS);
    }

    public static void clearPendingSync(UUID playerId) {
        PENDING_SYNC_PLAYERS.remove(playerId);
    }

    public static Set<UUID> getViewingPlayers() {
        return Set.copyOf(VIEWING_PLAYERS);
    }

    public static void cleanupPlayer(UUID playerId) {
        VIEWING_PLAYERS.remove(playerId);
        PENDING_SYNC_PLAYERS.remove(playerId);
    }

    public static String getStats() {
        return String.format("Viewing: %d, Pending: %d", VIEWING_PLAYERS.size(), PENDING_SYNC_PLAYERS.size());
    }
}

