/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.sync;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;

public class StorageSyncManager {
    private static final Map<UUID, SessionState> SESSION_BY_PLAYER = new ConcurrentHashMap<UUID, SessionState>();
    private static final Map<UUID, Map<String, SnapshotEntry>> LAST_SNAPSHOT_BY_PLAYER = new ConcurrentHashMap<UUID, Map<String, SnapshotEntry>>();

    public static long getOrStartSession(UUID playerId) {
        SessionState state = SESSION_BY_PLAYER.get(playerId);
        if (state == null) {
            long sid = StorageSyncManager.newSessionId();
            SESSION_BY_PLAYER.put(playerId, new SessionState(sid, 1));
            return sid;
        }
        return state.sessionId;
    }

    public static void startNewSession(UUID playerId) {
        long sid = StorageSyncManager.newSessionId();
        SESSION_BY_PLAYER.put(playerId, new SessionState(sid, 1));
    }

    public static int nextSeq(UUID playerId) {
        SessionState s = SESSION_BY_PLAYER.get(playerId);
        if (s == null) {
            StorageSyncManager.startNewSession(playerId);
            s = SESSION_BY_PLAYER.get(playerId);
        }
        int seq = s.nextSeq;
        SESSION_BY_PLAYER.put(playerId, new SessionState(s.sessionId, seq + 1));
        return seq;
    }

    private static long newSessionId() {
        return ThreadLocalRandom.current().nextLong();
    }

    public static void handleSyncAck(UUID playerId, long syncId, boolean success) {
    }

    public static void cleanupPlayer(UUID playerId) {
        SESSION_BY_PLAYER.remove(playerId);
        LAST_SNAPSHOT_BY_PLAYER.remove(playerId);
    }

    public static void forceFullSync(UUID playerId) {
        StorageSyncManager.startNewSession(playerId);
    }

    public static void shutdown() {
        SESSION_BY_PLAYER.clear();
        LAST_SNAPSHOT_BY_PLAYER.clear();
    }

    public static Map<String, SnapshotEntry> getLastSnapshot(UUID playerId) {
        return LAST_SNAPSHOT_BY_PLAYER.get(playerId);
    }

    public static void setLastSnapshot(UUID playerId, Map<String, SnapshotEntry> snapshot) {
        if (snapshot == null) {
            LAST_SNAPSHOT_BY_PLAYER.remove(playerId);
        } else {
            LAST_SNAPSHOT_BY_PLAYER.put(playerId, snapshot);
        }
    }

    private record SessionState(long sessionId, int nextSeq) {
    }

    public static final class SnapshotEntry {
        public final long count;
        public final long timestamp;

        public SnapshotEntry(long count, long timestamp) {
            this.count = count;
            this.timestamp = timestamp;
        }
    }
}

