/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.util;

import com.portable.storage.net.ServerNetworkingHandlers;
import com.portable.storage.newstore.NewStoreService;
import com.portable.storage.storage.FilterRuleManager;
import com.portable.storage.storage.StorageInventory;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_4174;
import net.minecraft.class_9334;

public class FoodUtils {
    public static boolean isFood(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        return stack.method_57824(class_9334.field_50075) != null;
    }

    public static boolean isEdible(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        return stack.method_57824(class_9334.field_50075) != null;
    }

    public static FoodInfo getFoodInfo(class_1799 stack) {
        if (stack.method_7960()) {
            return null;
        }
        class_4174 foodComponent = (class_4174)stack.method_57824(class_9334.field_50075);
        if (foodComponent == null) {
            return null;
        }
        return new FoodInfo(foodComponent.comp_2491(), foodComponent.comp_2492(), foodComponent.comp_2493(), foodComponent.comp_2494() < 1.0f);
    }

    public static boolean needsFood(class_3222 player, int threshold) {
        class_1702 hungerManager = player.method_7344();
        return hungerManager.method_7586() < threshold;
    }

    public static int getCurrentFoodLevel(class_3222 player) {
        class_1702 hungerManager = player.method_7344();
        return hungerManager.method_7586();
    }

    public static float getCurrentSaturationLevel(class_3222 player) {
        class_1702 hungerManager = player.method_7344();
        return hungerManager.method_7589();
    }

    public static boolean consumeFoodForPlayer(class_3222 player, class_1799 foodStack) {
        if (foodStack.method_7960() || !FoodUtils.isFood(foodStack)) {
            return false;
        }
        class_4174 foodComponent = (class_4174)foodStack.method_57824(class_9334.field_50075);
        if (foodComponent == null) {
            return false;
        }
        if (!player.method_7332(false)) {
            return false;
        }
        int nutrition = foodComponent.comp_2491();
        float saturation = foodComponent.comp_2492();
        class_1702 hungerManager = player.method_7344();
        hungerManager.method_7585(nutrition, saturation);
        if (!player.method_31549().field_7477) {
            foodStack.method_7934(1);
        }
        return true;
    }

    public static AutoEatResult autoEatFromStorage(class_3222 player, StorageInventory storage, int targetFoodLevel) {
        int finalFoodLevel;
        class_1799 templateStack;
        int bestFoodIndex;
        if (!FoodUtils.needsFood(player, targetFoodLevel)) {
            return new AutoEatResult(false, 0, 0, null);
        }
        int initialFoodLevel = FoodUtils.getCurrentFoodLevel(player);
        int totalConsumed = 0;
        String lastFoodName = null;
        while (FoodUtils.needsFood(player, targetFoodLevel) && (bestFoodIndex = FoodUtils.findMostAbundantFoodIndex(storage, player)) != -1 && !(templateStack = storage.getDisplayStack(bestFoodIndex)).method_7960() && FoodUtils.isFood(templateStack)) {
            String foodName = templateStack.method_7964().getString();
            long taken = storage.takeByIndex(bestFoodIndex, 1L, System.currentTimeMillis());
            if (taken <= 0L) break;
            class_1799 foodStack = templateStack.method_7972();
            foodStack.method_7939(1);
            if (!FoodUtils.consumeFoodForPlayer(player, foodStack)) continue;
            ++totalConsumed;
            lastFoodName = foodName;
        }
        boolean success = (finalFoodLevel = FoodUtils.getCurrentFoodLevel(player)) >= targetFoodLevel;
        return new AutoEatResult(success, totalConsumed, finalFoodLevel - initialFoodLevel, lastFoodName);
    }

    public static AutoEatResult autoEatFromNewStore(class_3222 player, int targetFoodLevel) {
        int finalFoodLevel;
        class_1799 templateStack;
        StorageInventory storage;
        int bestFoodIndex;
        if (!FoodUtils.needsFood(player, targetFoodLevel)) {
            return new AutoEatResult(false, 0, 0, null);
        }
        int initialFoodLevel = FoodUtils.getCurrentFoodLevel(player);
        int totalConsumed = 0;
        String lastFoodName = null;
        while (FoodUtils.needsFood(player, targetFoodLevel) && (bestFoodIndex = FoodUtils.findMostAbundantFoodIndex(storage = ServerNetworkingHandlers.buildMergedSnapshot(player), player)) != -1 && !(templateStack = storage.getDisplayStack(bestFoodIndex)).method_7960() && FoodUtils.isFood(templateStack)) {
            String foodName = templateStack.method_7964().getString();
            long taken = NewStoreService.takeForOnlinePlayer(player, templateStack, 1);
            if (taken <= 0L) break;
            class_1799 foodStack = templateStack.method_7972();
            foodStack.method_7939(1);
            if (!FoodUtils.consumeFoodForPlayer(player, foodStack)) continue;
            ++totalConsumed;
            lastFoodName = foodName;
        }
        boolean success = (finalFoodLevel = FoodUtils.getCurrentFoodLevel(player)) >= targetFoodLevel;
        return new AutoEatResult(success, totalConsumed, finalFoodLevel - initialFoodLevel, lastFoodName);
    }

    private static int findMostAbundantFoodIndex(StorageInventory storage, class_3222 player) {
        int bestIndex = -1;
        long maxCount = 0L;
        int capacity = storage.getCapacity();
        for (int i = 0; i < capacity; ++i) {
            boolean isFoodItem;
            class_1799 stack = storage.getDisplayStack(i);
            long count = storage.getCountByIndex(i);
            if (stack.method_7960() || count <= 0L || !(isFoodItem = FoodUtils.isFood(stack)) || !FilterRuleManager.shouldPickupItem(player, stack) || count <= maxCount) continue;
            maxCount = count;
            bestIndex = i;
        }
        return bestIndex;
    }

    public static class FoodInfo {
        public final int nutrition;
        public final float saturation;
        public final boolean isMeat;
        public final boolean isFastFood;

        public FoodInfo(int nutrition, float saturation, boolean isMeat, boolean isFastFood) {
            this.nutrition = nutrition;
            this.saturation = saturation;
            this.isMeat = isMeat;
            this.isFastFood = isFastFood;
        }
    }

    public static class AutoEatResult {
        public final boolean success;
        public final int itemsConsumed;
        public final int foodRestored;
        public final String lastFoodName;

        public AutoEatResult(boolean success, int itemsConsumed, int foodRestored, String lastFoodName) {
            this.success = success;
            this.itemsConsumed = itemsConsumed;
            this.foodRestored = foodRestored;
            this.lastFoodName = lastFoodName;
        }
    }
}

