/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.util;

import com.portable.storage.PortableStorage;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;

public final class SafeNbtIo {
    private static final String TEMP_SUFFIX = ".tmp";
    private static final String BACKUP_SUFFIX = ".bak";
    private static final String CORRUPT_SUFFIX = ".corrupt";
    private static final Set<Path> CORRUPT_FILES = ConcurrentHashMap.newKeySet();

    private SafeNbtIo() {
    }

    public static class_2487 readCompressed(Path file, class_2505 tracker) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        if (CORRUPT_FILES.contains(file)) {
            return null;
        }
        try {
            return class_2507.method_30613((Path)file, (class_2505)tracker);
        }
        catch (IOException e) {
            Path backupFile = file.resolveSibling(String.valueOf(file.getFileName()) + BACKUP_SUFFIX);
            if (Files.exists(backupFile, new LinkOption[0])) {
                try {
                    PortableStorage.LOGGER.warn("\u4e3b\u6587\u4ef6\u635f\u574f\uff0c\u5c1d\u8bd5\u4ece\u5907\u4efd\u6062\u590d: {}", (Object)file);
                    class_2487 backup = class_2507.method_30613((Path)backupFile, (class_2505)tracker);
                    if (backup != null) {
                        Files.move(backupFile, file, StandardCopyOption.REPLACE_EXISTING);
                        CORRUPT_FILES.remove(file);
                        PortableStorage.LOGGER.info("\u4ece\u5907\u4efd\u6210\u529f\u6062\u590d\u6587\u4ef6: {}", (Object)file);
                        return backup;
                    }
                }
                catch (IOException backupException) {
                    PortableStorage.LOGGER.warn("\u5907\u4efd\u6587\u4ef6\u4e5f\u635f\u574f: {}", (Object)backupFile, (Object)backupException);
                }
            }
            SafeNbtIo.isolateCorruptFile(file, e);
            return null;
        }
    }

    public static void writeCompressed(class_2487 nbt, Path file) throws IOException {
        if (nbt == null) {
            throw new IllegalArgumentException("NBT compound cannot be null");
        }
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Path tempFile = file.resolveSibling(String.valueOf(file.getFileName()) + TEMP_SUFFIX);
        Path backupFile = file.resolveSibling(String.valueOf(file.getFileName()) + BACKUP_SUFFIX);
        try {
            if (Files.exists(file, new LinkOption[0])) {
                Files.copy(file, backupFile, StandardCopyOption.REPLACE_EXISTING);
            }
            class_2507.method_30614((class_2487)nbt, (Path)tempFile);
            try (SeekableByteChannel channel2 = Files.newByteChannel(tempFile, Set.of(StandardOpenOption.WRITE, StandardOpenOption.SYNC), new FileAttribute[0]);){
                if (channel2 instanceof FileChannel) {
                    FileChannel fc = (FileChannel)channel2;
                    fc.force(true);
                }
            }
            catch (IOException | UnsupportedOperationException channel2) {
                // empty catch block
            }
            Files.move(tempFile, file, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            try {
                class_2487 verify = class_2507.method_30613((Path)file, (class_2505)class_2505.method_53898());
                if (verify == null || !verify.equals((Object)nbt)) {
                    throw new IOException("\u5199\u5165\u9a8c\u8bc1\u5931\u8d25");
                }
            }
            catch (IOException verifyException) {
                if (Files.exists(backupFile, new LinkOption[0])) {
                    Files.move(backupFile, file, StandardCopyOption.REPLACE_EXISTING);
                    throw new IOException("\u5199\u5165\u9a8c\u8bc1\u5931\u8d25\uff0c\u5df2\u6062\u590d\u5907\u4efd", verifyException);
                }
                throw verifyException;
            }
            try {
                Files.deleteIfExists(backupFile);
            }
            catch (IOException verifyException) {}
        }
        catch (IOException e) {
            try {
                Files.deleteIfExists(tempFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    private static void isolateCorruptFile(Path file, IOException originalException) {
        try {
            Path corruptFile = file.resolveSibling(String.valueOf(file.getFileName()) + CORRUPT_SUFFIX);
            Files.move(file, corruptFile, StandardCopyOption.REPLACE_EXISTING);
            CORRUPT_FILES.add(file);
            PortableStorage.LOGGER.error("\u68c0\u6d4b\u5230\u635f\u574f\u7684NBT\u6587\u4ef6\uff0c\u5df2\u9694\u79bb: {} -> {}", new Object[]{file, corruptFile, originalException});
        }
        catch (IOException e) {
            PortableStorage.LOGGER.error("\u65e0\u6cd5\u9694\u79bb\u635f\u574f\u6587\u4ef6: {}", (Object)file, (Object)e);
        }
    }

    public static boolean isCorrupt(Path file) {
        return CORRUPT_FILES.contains(file);
    }

    public static void clearCorruptMark(Path file) {
        CORRUPT_FILES.remove(file);
    }

    public static Set<Path> getCorruptFiles() {
        return Set.copyOf(CORRUPT_FILES);
    }

    public static int scanForCorruptFiles(Path directory) {
        if (!Files.exists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            return 0;
        }
        int corruptCount = 0;
        try (Stream<Path> stream = Files.list(directory);){
            for (Path file : stream.toList()) {
                if (!file.getFileName().toString().endsWith(".nbt") || SafeNbtIo.isCorrupt(file)) continue;
                try {
                    class_2507.method_30613((Path)file, (class_2505)class_2505.method_53898());
                }
                catch (IOException e) {
                    SafeNbtIo.isolateCorruptFile(file, e);
                    ++corruptCount;
                }
            }
        }
        catch (IOException e) {
            PortableStorage.LOGGER.error("\u626b\u63cf\u635f\u574f\u6587\u4ef6\u65f6\u51fa\u9519: {}", (Object)directory, (Object)e);
        }
        return corruptCount;
    }
}

