/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_3222;

public class StorageActivationConfirmation {
    private static final Map<UUID, Long> pendingConfirmations = new HashMap<UUID, Long>();
    private static final long CONFIRMATION_TIMEOUT = 5000L;

    public static boolean hasPendingConfirmation(class_3222 player) {
        UUID playerId = player.method_5667();
        Long timestamp = pendingConfirmations.get(playerId);
        if (timestamp == null) {
            return false;
        }
        if (System.currentTimeMillis() - timestamp > 5000L) {
            pendingConfirmations.remove(playerId);
            return false;
        }
        return true;
    }

    public static void setPendingConfirmation(class_3222 player) {
        pendingConfirmations.put(player.method_5667(), System.currentTimeMillis());
    }

    public static boolean confirmActivation(class_3222 player) {
        UUID playerId = player.method_5667();
        Long timestamp = pendingConfirmations.get(playerId);
        if (timestamp == null) {
            return false;
        }
        if (System.currentTimeMillis() - timestamp > 5000L) {
            pendingConfirmations.remove(playerId);
            return false;
        }
        pendingConfirmations.remove(playerId);
        return true;
    }

    public static void cancelPendingConfirmation(class_3222 player) {
        pendingConfirmations.remove(player.method_5667());
    }

    public static void cleanupExpiredConfirmations() {
        long currentTime = System.currentTimeMillis();
        pendingConfirmations.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 5000L);
    }
}

