/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.util;

import com.portable.storage.PortableStorage;
import com.portable.storage.item.StorageKeyItem;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8111;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class StorageKeyProtection {
    private StorageKeyProtection() {
    }

    public static boolean canPickup(class_1657 player, class_1799 stack) {
        if (!StorageKeyItem.isStorageKey(stack)) {
            return true;
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            return StorageKeyItem.isOwner(serverPlayer, stack);
        }
        return false;
    }

    public static boolean canUse(class_1657 player, class_1799 stack) {
        if (!StorageKeyItem.isStorageKey(stack)) {
            return true;
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            return StorageKeyItem.isOwner(serverPlayer, stack);
        }
        return false;
    }

    public static boolean canDestroy(class_1657 player, class_1799 stack) {
        if (!StorageKeyItem.isStorageKey(stack)) {
            return true;
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            return StorageKeyItem.isOwner(serverPlayer, stack);
        }
        return false;
    }

    public static void handleUnauthorizedPickup(class_3222 player, class_1799 stack) {
        if (!StorageKeyItem.isStorageKey(stack)) {
            return;
        }
    }

    public static void handleUnauthorizedUse(class_3222 player, class_1799 stack) {
        if (!StorageKeyItem.isStorageKey(stack)) {
            return;
        }
        String ownerName = StorageKeyProtection.getOwnerName(stack);
        if (ownerName != null) {
            player.method_7353((class_2561)class_2561.method_43469((String)"portable-storage.message.key_belongs_to", (Object[])new Object[]{ownerName}).method_27692(class_124.field_1061), false);
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.message.key_unauthorized").method_27692(class_124.field_1061), false);
        }
    }

    public static void handleUnauthorizedDestroy(class_3222 player, class_1799 stack) {
        if (!StorageKeyItem.isStorageKey(stack)) {
            return;
        }
        player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.message.key_indestructible").method_27692(class_124.field_1061), false);
    }

    public static boolean preventDestroy(class_1542 itemEntity, class_1282 source) {
        class_1799 stack = itemEntity.method_6983();
        if (!StorageKeyItem.isStorageKey(stack)) {
            return false;
        }
        if (source.method_49708(class_8111.field_42338) || source.method_49708(class_8111.field_42335) || source.method_49708(class_8111.field_42337)) {
            return true;
        }
        if (source.method_49708(class_8111.field_42347)) {
            PortableStorage.LOGGER.info("Storage key void protection triggered at position ({}, {}, {})", new Object[]{itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321()});
            double x = itemEntity.method_23317();
            double z = itemEntity.method_23321();
            double safeY = Math.max(itemEntity.method_37908().method_31607() + 1, 1);
            itemEntity.method_5814(x, safeY, z);
            itemEntity.method_18800(0.0, 0.4, 0.0);
            PortableStorage.LOGGER.info("Storage key teleported to safe position ({}, {}, {})", new Object[]{x, safeY, z});
            return true;
        }
        return source.method_49708(class_8111.field_42344) || source.method_49708(class_8111.field_42353);
    }

    private static String getOwnerName(class_1799 stack) {
        if (!StorageKeyItem.isStorageKey(stack)) {
            return null;
        }
        try {
            class_2487 nbtCompound;
            class_9279 customData = (class_9279)stack.method_57824(class_9334.field_49628);
            if (customData != null && (nbtCompound = customData.method_57461()).method_10545("storage_key_owner_name")) {
                return nbtCompound.method_10558("storage_key_owner_name");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

