/*
 * Decompiled with CFR 0.152.
 */
package com.portable.storage.world;

import com.portable.storage.PortableStorage;
import com.portable.storage.config.ServerConfig;
import com.portable.storage.entity.RiftAvatarEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_5889;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public final class SpaceRiftManager {
    public static final class_2960 DIM_ID = class_2960.method_60655((String)"portable-storage", (String)"space_rift");
    public static final class_5321<class_1937> DIMENSION_KEY = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)DIM_ID);
    private static final Map<UUID, class_1923> playerPlotOrigin = new HashMap<UUID, class_1923>();
    private static final Map<UUID, class_4208> playerReturnPoint = new HashMap<UUID, class_4208>();
    private static final Map<UUID, class_2784> personalBorders = new HashMap<UUID, class_2784>();
    private static final Map<UUID, class_1297> avatars = new HashMap<UUID, class_1297>();
    private static final Map<UUID, class_2338> lastRiftPos = new HashMap<UUID, class_2338>();
    private static final int PLOT_SPACING_CHUNKS = 64;
    private static final int PLOT_HEIGHT = 100;
    private static final int FLOOR_Y = 64;
    private static final int BOTTOM_Y = 0;
    private static final int TOP_Y = 164;

    private SpaceRiftManager() {
    }

    public static class_3218 getWorld(MinecraftServer server) {
        return server.method_3847(DIMENSION_KEY);
    }

    public static class_1923 ensureAllocatedPlot(MinecraftServer server, UUID playerId) {
        return playerPlotOrigin.computeIfAbsent(playerId, id -> SpaceRiftManager.allocatePlotFor(id));
    }

    private static class_1923 allocatePlotFor(UUID playerId) {
        int index = Math.floorMod(playerId.hashCode(), 1024);
        int x = index * 64;
        int z = 0;
        return new class_1923(x, z);
    }

    public static class_2338 getPlotCenterBlock(class_1923 origin) {
        int chunkSize = SpaceRiftManager.getPlotChunkSize();
        int centerOffset = (chunkSize - 1) * 8;
        int x = origin.method_33940() + centerOffset;
        int z = origin.method_33942() + centerOffset;
        return new class_2338(x, 65, z);
    }

    public static void rememberReturnPoint(class_3222 player) {
        playerReturnPoint.put(player.method_5667(), class_4208.method_19443((class_5321)player.method_37908().method_27983(), (class_2338)player.method_24515()));
    }

    public static class_4208 getReturnPoint(UUID playerId) {
        return playerReturnPoint.get(playerId);
    }

    public static void clearReturnPoint(UUID playerId) {
        playerReturnPoint.remove(playerId);
    }

    public static boolean isInsideOwnPlot(class_3222 player, class_2338 pos) {
        boolean insideXZ;
        class_1923 origin = playerPlotOrigin.get(player.method_5667());
        if (origin == null) {
            return false;
        }
        int minX = origin.method_8326();
        int minZ = origin.method_8328();
        int maxX = minX + 16 * SpaceRiftManager.getPlotChunkSize() - 1;
        int maxZ = minZ + 16 * SpaceRiftManager.getPlotChunkSize() - 1;
        boolean bl = insideXZ = pos.method_10263() >= minX && pos.method_10263() <= maxX && pos.method_10260() >= minZ && pos.method_10260() <= maxZ;
        if (ServerConfig.getInstance().isLimitRiftHeight()) {
            return insideXZ && pos.method_10264() >= 0 && pos.method_10264() < 164;
        }
        return insideXZ;
    }

    public static void ensurePlotInitialized(class_3218 world, class_1923 origin) {
        world.method_8497(origin.field_9181, origin.field_9180);
        class_2680 stone = class_2246.field_10360.method_9564();
        class_2680 barrier = class_2246.field_10499.method_9564();
        int minX = origin.method_8326();
        int minZ = origin.method_8328();
        int maxX = minX + 16 * SpaceRiftManager.getPlotChunkSize() - 1;
        int maxZ = minZ + 16 * SpaceRiftManager.getPlotChunkSize() - 1;
        int worldBottom = world.method_31607();
        int worldTop = world.method_31600() - 1;
        int bottomStart = Math.max(0, worldBottom);
        int bottomEnd = Math.min(bottomStart + 9, worldTop);
        int topEnd = Math.min(164, worldTop);
        int topStart = Math.max(topEnd - 9, worldBottom);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int y;
                world.method_8501(new class_2338(x, 64, z), stone);
                if (!ServerConfig.getInstance().isLimitRiftHeight()) continue;
                for (y = bottomStart; y <= bottomEnd; ++y) {
                    world.method_8501(new class_2338(x, y, z), barrier);
                }
                for (y = topStart; y <= topEnd; ++y) {
                    world.method_8501(new class_2338(x, y, z), barrier);
                }
            }
        }
    }

    public static void applyPersonalBorder(class_3222 player) {
        if (player.method_7337() || player.method_7325()) {
            SpaceRiftManager.resetToWorldBorder(player);
            return;
        }
        class_1923 origin = playerPlotOrigin.get(player.method_5667());
        if (origin == null) {
            return;
        }
        class_2338 center = SpaceRiftManager.getPlotCenterBlock(origin);
        class_2784 border = new class_2784();
        border.method_11978((double)center.method_10263(), (double)center.method_10260());
        double borderSize = (double)SpaceRiftManager.getPlotChunkSize() * 16.0;
        border.method_11969(borderSize);
        border.method_11967(0);
        border.method_11975(0);
        personalBorders.put(player.method_5667(), border);
        player.field_13987.method_14364((class_2596)new class_5889(border));
    }

    public static void resetToWorldBorder(class_3222 player) {
        personalBorders.remove(player.method_5667());
        class_2784 worldBorder = player.method_37908().method_8621();
        player.field_13987.method_14364((class_2596)new class_5889(worldBorder));
    }

    public static void ensureAvatarOnExit(class_3222 player) {
        class_3218 rift = SpaceRiftManager.getWorld(player.method_5682());
        if (rift == null) {
            return;
        }
        class_2338 lastPos = lastRiftPos.get(player.method_5667());
        if (lastPos != null && SpaceRiftManager.isInRiftVoid(rift, lastPos)) {
            SpaceRiftManager.removeAvatar(player);
            PortableStorage.LOGGER.debug("Player {} last position was in rift void, no avatar created", (Object)player.method_5477().getString());
            return;
        }
        SpaceRiftManager.removeAvatar(player);
        class_1923 origin = SpaceRiftManager.ensureAllocatedPlot(player.method_5682(), player.method_5667());
        class_2338 center = SpaceRiftManager.getPlotCenterBlock(origin);
        class_2338 recorded = lastRiftPos.getOrDefault(player.method_5667(), center);
        class_2338 pos = SpaceRiftManager.clampToPlot(origin, recorded);
        try {
            RiftAvatarEntity avatar = RiftAvatarEntity.spawn(rift, pos, player.method_5667());
            if (avatar != null) {
                avatar.method_5665((class_2561)class_2561.method_43469((String)"portable-storage.rift_avatar", (Object[])new Object[]{player.method_5477().getString()}));
            }
            avatars.put(player.method_5667(), (class_1297)avatar);
            PortableStorage.LOGGER.debug("Rift avatar created for {} at {}", (Object)player.method_5477().getString(), (Object)pos);
        }
        catch (Throwable t) {
            PortableStorage.LOGGER.error("Failed to create rift avatar for {}", (Object)player.method_5477().getString(), (Object)t);
        }
    }

    public static void updateLastRiftPos(class_3222 player) {
        lastRiftPos.put(player.method_5667(), player.method_24515());
    }

    public static boolean isInRiftVoid(class_3218 world, class_2338 pos) {
        return world.method_27983() == DIMENSION_KEY && pos.method_10264() < world.method_31607();
    }

    private static class_2338 clampToPlot(class_1923 origin, class_2338 pos) {
        int minX = origin.method_8326();
        int minZ = origin.method_8328();
        int maxX = minX + 16 * SpaceRiftManager.getPlotChunkSize() - 1;
        int maxZ = minZ + 16 * SpaceRiftManager.getPlotChunkSize() - 1;
        int x = Math.min(Math.max(pos.method_10263(), minX), maxX);
        int z = Math.min(Math.max(pos.method_10260(), minZ), maxZ);
        int y = Math.max(pos.method_10264(), 0);
        return new class_2338(x, y, z);
    }

    public static void removeAvatar(class_3222 player) {
        class_1297 e = avatars.remove(player.method_5667());
        if (e != null) {
            e.method_31472();
        }
    }

    public static class_1923 getPlayerPlotOrigin(UUID playerId) {
        return playerPlotOrigin.get(playerId);
    }

    public static int getPlotChunkSize() {
        return ServerConfig.getInstance().getRiftSize();
    }

    public static void safelyKickPlayerFromRift(class_3222 player) {
        try {
            UUID id = player.method_5667();
            class_4208 returnPoint = SpaceRiftManager.getReturnPoint(id);
            SpaceRiftManager.setPlayerPlotForced(player.method_5682(), id, false);
            if (returnPoint != null) {
                class_3218 targetWorld = player.method_5682().method_3847(returnPoint.comp_2207());
                if (targetWorld != null) {
                    class_2338 pos = returnPoint.comp_2208();
                    player.method_14251(targetWorld, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, player.method_36454(), player.method_36455());
                    player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.rift_feature_disabled_returned"), true);
                    SpaceRiftManager.clearReturnPoint(id);
                    SpaceRiftManager.removeAvatar(player);
                } else {
                    class_3218 overworld = player.method_5682().method_30002();
                    class_2338 spawn = overworld.method_43126();
                    player.method_14251(overworld, (double)spawn.method_10263() + 0.5, (double)spawn.method_10264(), (double)spawn.method_10260() + 0.5, player.method_36454(), player.method_36455());
                    player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.rift_feature_disabled_returned"), true);
                    SpaceRiftManager.clearReturnPoint(id);
                    SpaceRiftManager.removeAvatar(player);
                }
            } else {
                class_3218 overworld = player.method_5682().method_30002();
                class_2338 spawn = overworld.method_43126();
                player.method_14251(overworld, (double)spawn.method_10263() + 0.5, (double)spawn.method_10264(), (double)spawn.method_10260() + 0.5, player.method_36454(), player.method_36455());
                player.method_7353((class_2561)class_2561.method_43471((String)"portable-storage.rift_feature_disabled_returned"), true);
                SpaceRiftManager.removeAvatar(player);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class_2338 getAvatarPositionOrCenter(class_3222 player, class_1923 origin) {
        class_1297 avatar = avatars.get(player.method_5667());
        if (avatar != null && !avatar.method_31481()) {
            return avatar.method_24515();
        }
        return SpaceRiftManager.getPlotCenterBlock(origin);
    }

    public static void setPlayerPlotForced(MinecraftServer server, UUID playerId, boolean forced) {
        class_3218 rift = SpaceRiftManager.getWorld(server);
        if (rift == null) {
            return;
        }
        class_1923 origin = SpaceRiftManager.ensureAllocatedPlot(server, playerId);
        try {
            rift.method_17988(origin.field_9181, origin.field_9180, forced);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

