/*
 * Decompiled with CFR 0.152.
 */
package net.terraxyz.treerific.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.terraxyz.treerific.datagen.ModBlockLootTableProvider;
import net.terraxyz.treerific.datagen.ModBlockStateProvider;
import net.terraxyz.treerific.datagen.ModBlockTagProvider;
import net.terraxyz.treerific.datagen.ModItemModelProvider;
import net.terraxyz.treerific.datagen.ModItemTagProvider;
import net.terraxyz.treerific.datagen.ModRecipeProvider;
import net.terraxyz.treerific.datagen.ModWorldGenProvider;

@Mod.EventBusSubscriber(modid="treerific", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
            generator.addProvider(true, (DataProvider)new ModRecipeProvider(packOutput, lookupProvider));
            ModBlockTagProvider blockTagsProvider = new ModBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
            generator.addProvider(true, (DataProvider)blockTagsProvider);
            generator.addProvider(true, (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
            generator.addProvider(true, (DataProvider)new ModWorldGenProvider(packOutput, lookupProvider));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
            generator.addProvider(true, (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        }
    }
}

