/*
 * Decompiled with CFR 0.152.
 */
package net.terraxyz.treerific.worldgen;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.terraxyz.treerific.worldgen.ModPlacedFeatures;

public class ModBiomeModifiers {
    public static final ResourceKey<BiomeModifier> ADD_STONEWOOD_TREE = ModBiomeModifiers.registerKey("add_tree_stonewood");
    public static final ResourceKey<BiomeModifier> ADD_ELM_TREE = ModBiomeModifiers.registerKey("add_tree_elm");
    public static final ResourceKey<BiomeModifier> ADD_REDWOOD_TREE = ModBiomeModifiers.registerKey("add_tree_redwood");
    public static final ResourceKey<BiomeModifier> ADD_SEQUOIA_TREE = ModBiomeModifiers.registerKey("add_tree_sequoia");

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter placedFeature = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        context.register(ADD_STONEWOOD_TREE, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.STONY_PEAKS)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeature.getOrThrow(ModPlacedFeatures.STONEWOOD_PLACED_KEY)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_ELM_TREE, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.THE_VOID)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeature.getOrThrow(ModPlacedFeatures.ELM_PLACED_KEY)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_REDWOOD_TREE, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.THE_VOID)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeature.getOrThrow(ModPlacedFeatures.REDWOOD_PLACED_KEY)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_SEQUOIA_TREE, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.THE_VOID)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeature.getOrThrow(ModPlacedFeatures.SEQUOIA_PLACED_KEY)}), GenerationStep.Decoration.VEGETAL_DECORATION));
    }

    private static ResourceKey<BiomeModifier> registerKey(String name) {
        return ResourceKey.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"treerific", (String)name));
    }
}

