/*
 * Decompiled with CFR 0.152.
 */
package net.terraxyz.treerific.worldgen;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.terraxyz.treerific.block.ModBlocks;
import net.terraxyz.treerific.worldgen.ModConfiguredFeatures;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> STONEWOOD_PLACED_KEY = ModPlacedFeatures.registerKey("stonewood_placed");
    public static final ResourceKey<PlacedFeature> ELM_PLACED_KEY = ModPlacedFeatures.registerKey("elm_placed");
    public static final ResourceKey<PlacedFeature> REDWOOD_PLACED_KEY = ModPlacedFeatures.registerKey("redwood_placed");
    public static final ResourceKey<PlacedFeature> SEQUOIA_PLACED_KEY = ModPlacedFeatures.registerKey("sequoia_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, STONEWOOD_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.STONEWOOD_KEY), VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)3), (Block)((Block)ModBlocks.STONEWOOD_SAPLING.get())));
        ModPlacedFeatures.register(context, ELM_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.ELM_KEY), VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)1), (Block)((Block)ModBlocks.ELM_SAPLING.get())));
        ModPlacedFeatures.register(context, REDWOOD_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.REDWOOD_KEY), VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)1), (Block)((Block)ModBlocks.REDWOOD_SAPLING.get())));
        ModPlacedFeatures.register(context, SEQUOIA_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.SEQUOIA_KEY), VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)1), (Block)((Block)ModBlocks.SEQUOIA_SAPLING.get())));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"treerific", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

