/*
 * Decompiled with CFR 0.152.
 */
package net.terraxyz.treerific.worldgen.biome;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.terraxyz.treerific.worldgen.biome.ModOverworldBiomes;
import net.terraxyz.treerific.worldgen.biome.region.OverworldRegion;
import terrablender.api.Region;
import terrablender.api.Regions;

public class ModBiomes {
    public static final ResourceKey<Biome> REDWOOD_FOREST = ModBiomes.registerBiomeKey("redwood_forest");
    public static final ResourceKey<Biome> ELM_ORCHARD = ModBiomes.registerBiomeKey("elm_orchard");
    public static final ResourceKey<Biome> SEQUOIA_FOREST = ModBiomes.registerBiomeKey("sequoia_forest");

    public static void registerBiomes() {
        Regions.register((Region)new OverworldRegion(ResourceLocation.fromNamespaceAndPath((String)"treerific", (String)"treerific_overworld"), 20));
    }

    public static void bootstrap(BootstrapContext<Biome> context) {
        HolderGetter carver = context.lookup(Registries.CONFIGURED_CARVER);
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        ModBiomes.register(context, REDWOOD_FOREST, ModOverworldBiomes.redwoodForest((HolderGetter<PlacedFeature>)placedFeatures, carver));
        ModBiomes.register(context, ELM_ORCHARD, ModOverworldBiomes.elmOrchard((HolderGetter<PlacedFeature>)placedFeatures, carver));
        ModBiomes.register(context, SEQUOIA_FOREST, ModOverworldBiomes.sequoiaForest((HolderGetter<PlacedFeature>)placedFeatures, carver));
    }

    private static void register(BootstrapContext<Biome> context, ResourceKey<Biome> key, Biome biome) {
        context.register(key, (Object)biome);
    }

    private static ResourceKey<Biome> registerBiomeKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"treerific", (String)name));
    }
}

