/*
 * Decompiled with CFR 0.152.
 */
package net.choicetheorem.ctov;

import net.choicetheorem.ctov.platform.CTOVConfigHelper;
import net.choicetheorem.ctov.utils.CTOVStructureHelper;
import net.choicetheorem.ctov.utils.TextUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class CTOV {
    public static final String MOD_ID = "ctov";

    public static void init() {
    }

    public static void registerstructure(MinecraftServer server) {
        ResourceLocation villagelocation;
        RegistryAccess.Frozen registryProvider = server.registryAccess();
        HolderLookup.RegistryLookup StructureSetRegistry = registryProvider.lookupOrThrow(Registries.STRUCTURE_SET);
        HolderLookup.RegistryLookup StructureRegistry = registryProvider.lookupOrThrow(Registries.STRUCTURE);
        String[] enabledpillageroutpost = new String[]{"beach", "dark_forest", "desert", "jungle", "badlands", "mountain", "plains", "savanna", "snowy", "swamp", "taiga"};
        String[] enabledvillage = new String[]{"beach", "christmas", "desert", "desert_oasis", "dark_forest", "jungle", "jungle_tree", "mesa", "mesa_fortified", "mountain", "mountain_alpine", "mushroom", "plains", "plains_fortified", "savanna", "savanna_na", "snowy_igloo", "swamp", "swamp_fortified", "taiga", "taiga_fortified"};
        ResourceLocation villagesetLocation = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"villages");
        ResourceLocation outpostsetLocation = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"pillager_outposts");
        if (CTOVConfigHelper.generatePillagerOutpost()) {
            for (String outpost : enabledpillageroutpost) {
                ResourceLocation pillagerlocation = TextUtils.res("pillager_outpost_" + outpost);
                new CTOVStructureHelper(server, (HolderLookup<StructureSet>)StructureSetRegistry, (HolderLookup<Structure>)StructureRegistry, outpostsetLocation, pillagerlocation, CTOVConfigHelper.OutpostWeight());
            }
        }
        if (CTOVConfigHelper.generatesmallVillage()) {
            for (String village : enabledvillage) {
                villagelocation = TextUtils.res("small/village_" + village);
                new CTOVStructureHelper(server, (HolderLookup<StructureSet>)StructureSetRegistry, (HolderLookup<Structure>)StructureRegistry, villagesetLocation, villagelocation, CTOVConfigHelper.smallVillageWeight());
            }
        }
        if (CTOVConfigHelper.generatemediumVillage()) {
            for (String village : enabledvillage) {
                villagelocation = TextUtils.res("medium/village_" + village);
                new CTOVStructureHelper(server, (HolderLookup<StructureSet>)StructureSetRegistry, (HolderLookup<Structure>)StructureRegistry, villagesetLocation, villagelocation, CTOVConfigHelper.mediumVillageWeight());
            }
        }
        if (CTOVConfigHelper.generatelargeVillage()) {
            for (String village : enabledvillage) {
                villagelocation = TextUtils.res("large/village_" + village);
                new CTOVStructureHelper(server, (HolderLookup<StructureSet>)StructureSetRegistry, (HolderLookup<Structure>)StructureRegistry, villagesetLocation, villagelocation, CTOVConfigHelper.largeVillageWeight());
            }
        }
    }
}

