/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.multiworld.command;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import me.isaiah.multiworld.MultiworldMod;
import me.isaiah.multiworld.command.Command;
import me.isaiah.multiworld.command.Util;
import me.isaiah.multiworld.config.FileConfiguration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class GameruleCommand
implements Command {
    public static HashMap<String, GameRules.Key> keys = new HashMap();

    public static GameRules getGameRules(ServerLevel world) {
        return world.getGameRules();
    }

    public static int run(MinecraftServer mc, ServerPlayer plr, String[] args) {
        ServerLevel w = (ServerLevel)plr.level();
        if (keys.isEmpty()) {
            GameruleCommand.setup(w);
        }
        if (args.length < 3) {
            GameRules.Value rule = GameruleCommand.getGameRules(w).getRule(keys.get(args[1]));
            MultiworldMod.message((Player)plr, "[&4Multiworld&r] Value of " + args[1] + " is: " + String.valueOf(rule));
            return 1;
        }
        String a1 = args[1];
        String a2 = args[2];
        boolean is_bol = false;
        if (a2.equalsIgnoreCase("true") || a2.equalsIgnoreCase("false")) {
            is_bol = true;
        }
        if (is_bol) {
            rule = (GameRules.BooleanValue)GameruleCommand.getGameRules(w).getRule(keys.get(a1));
            rule.set(Boolean.valueOf(a2).booleanValue(), mc);
        } else {
            rule = (GameRules.IntegerValue)GameruleCommand.getGameRules(w).getRule(keys.get(a1));
            rule.set(Integer.valueOf(a2).intValue(), mc);
        }
        try {
            GameruleCommand.set_rule_cfg((Level)w, a1, a2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MultiworldMod.message((Player)plr, "[&cMultiworld&r]: Gamerule " + a1 + " is now set to: " + a2);
        return 1;
    }

    public static void setupServer(MinecraftServer server) {
        keys.clear();
        server.getGameRules().visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

            public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> key, GameRules.Type<T> type) {
                String name = key.getId();
                keys.put(name, key);
            }
        });
    }

    public static void setup(ServerLevel world) {
        keys.clear();
        world.getGameRules().visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

            public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> key, GameRules.Type<T> type) {
                String name = key.getId();
                keys.put(name, key);
            }
        });
    }

    public static void set_rule_cfg(Level w, String a, String b) throws IOException {
        File cf = new File(Util.get_platform_config_dir(), "multiworld");
        cf.mkdirs();
        File worlds = new File(cf, "worlds");
        worlds.mkdirs();
        ResourceLocation id = w.dimension().location();
        File namespace = new File(worlds, id.getNamespace());
        namespace.mkdirs();
        File wc = new File(namespace, id.getPath() + ".yml");
        wc.createNewFile();
        FileConfiguration config = new FileConfiguration(wc);
        if (!config.is_set("gamerules")) {
            config.set("gamerules", new ArrayList());
        }
        config.set("gamerule_" + a, b);
        config.save();
    }

    public static void set_gamerule_from_cfg(ServerLevel world, String key, String val) {
        if (keys.isEmpty()) {
            GameruleCommand.setup(world);
        }
        String name = key.replace("gamerule_", "").trim();
        String a1 = val.trim();
        boolean is_bol = false;
        if (a1.equalsIgnoreCase("true") || a1.equalsIgnoreCase("false")) {
            is_bol = true;
        }
        if (is_bol) {
            GameRules.BooleanValue rule = (GameRules.BooleanValue)GameruleCommand.getGameRules(world).getRule(keys.get(name));
            rule.set(Boolean.valueOf(a1).booleanValue(), MultiworldMod.mc);
        } else {
            GameRules.IntegerValue rule = (GameRules.IntegerValue)GameruleCommand.getGameRules(world).getRule(keys.get(name));
            rule.set(Integer.valueOf(a1).intValue(), MultiworldMod.mc);
        }
    }
}

