/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.multiworld.command;

import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import me.isaiah.multiworld.InfoSuggest;
import me.isaiah.multiworld.MultiworldMod;
import me.isaiah.multiworld.command.Command;
import me.isaiah.multiworld.command.Util;
import me.isaiah.multiworld.perm.Perm;
import me.isaiah.multiworld.portal.Portal;
import me.isaiah.multiworld.portal.WandEventHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class PortalCommand
implements Command {
    public static HashMap<String, Portal> KNOWN_PORTALS = new HashMap();
    public static String[] COMMAND_HELP = new String[]{"Multiworld Portals Command:", "&a/mw portal create <name> [destination]&r - Creates a new portal from the wand area", "&a/mw portal select <name>&r - TODO", "&a/mw portal wand&r - Gives a Portal Creation Wand", "&a/mw portal info <name>&r - Displays information about a portal.", "&a/mw portal remove <name>&r - TODO"};
    public static String[] SUBCOMMANDS = new String[]{"create", "wand", "info"};

    public static void addKnownPortal(String key, Portal value) {
        String lower = key.toLowerCase(Locale.ROOT);
        KNOWN_PORTALS.put(lower, value);
    }

    public static Portal getKnownPortal(String key) {
        String lower = key.toLowerCase(Locale.ROOT);
        return KNOWN_PORTALS.get(lower);
    }

    public static int run(MinecraftServer mc, ServerPlayer plr, String[] args) {
        Portal p3;
        Object name;
        if (args.length == 1) {
            for (String s : COMMAND_HELP) {
                MultiworldMod.message((Player)plr, s);
            }
            return 0;
        }
        if (!Util.isForgeOrHasICommon()) {
            MultiworldMod.message((Player)plr, "&4WARN: iCommonLib is required for Portals to function properly");
        }
        if (args[1].equalsIgnoreCase("refresh")) {
            if (args.length < 3) {
                for (Portal p2 : KNOWN_PORTALS.values()) {
                    p2.refreshPortalArea();
                }
                return 1;
            }
            name = args[2];
            p3 = KNOWN_PORTALS.getOrDefault(name, PortalCommand.getPortalIgnoreCase((String)name));
            if (null == p3) {
                MultiworldMod.message((Player)plr, "&4Portal with the name " + (String)name + " not found!");
            }
            p3.refreshPortalArea();
        }
        if (args[1].equalsIgnoreCase("info")) {
            if (args.length < 3) {
                MultiworldMod.message((Player)plr, "&6Multiworld Portals (" + KNOWN_PORTALS.size() + "):");
                for (Portal p3 : KNOWN_PORTALS.values()) {
                    MultiworldMod.message((Player)plr, " Portal: \"" + p3.getName() + "\": ");
                    String from = String.valueOf(p3.getOriginWorldId()) + " (" + p3.getMinPos().toShortString();
                    String to = p3.getDestWorldName() + " (" + p3.getDestLocation().toShortString();
                    MultiworldMod.message((Player)plr, " - " + from + ") -> " + to + ")");
                }
                return 1;
            }
            name = args[2];
            p3 = KNOWN_PORTALS.getOrDefault(name, PortalCommand.getPortalIgnoreCase((String)name));
            if (null == p3) {
                MultiworldMod.message((Player)plr, "&4Portal with the name " + (String)name + " not found!");
            }
            MultiworldMod.message((Player)plr, "&6Multiworld Portals:");
            MultiworldMod.message((Player)plr, " Portal: \"" + p3.getName() + "\": ");
            MultiworldMod.message((Player)plr, "  &6- From:&r " + String.valueOf(p3.getOriginWorldId()) + " @ (" + p3.getMinPos().toShortString() + ")");
            MultiworldMod.message((Player)plr, "  &6- To:&r " + p3.getDestWorldName() + " @ (" + p3.getDestLocation().toShortString() + ")");
            MultiworldMod.message((Player)plr, "  &6- Destination:&r " + p3.getDestination());
            MultiworldMod.message((Player)plr, "  &6- Portal Frame:&r " + p3.getLocationConfigString());
        }
        if (args[1].equalsIgnoreCase("wand")) {
            if (!Perm.has(plr, "multiworld.portal.wand")) {
                MultiworldMod.message((Player)plr, "Invalid permission! Missing: multiworld.portal.wand");
                return 0;
            }
            MultiworldMod.message((Player)plr, "&aGiving wand!");
            plr.addItem(WandEventHandler.getItemStack().copy());
            return 1;
        }
        if (args.length == 2) {
            MultiworldMod.message((Player)plr, "&4Usage: /mw portal <subcommand> [arguments]");
            return 0;
        }
        if (args[1].equalsIgnoreCase("create")) {
            if (args.length < 4) {
                MultiworldMod.message((Player)plr, "&4Usage: /mw portal create <name> <destination>");
                return 0;
            }
            if (!Perm.has(plr, "multiworld.portal.create")) {
                MultiworldMod.message((Player)plr, "Invalid permission! Missing: multiworld.portal.create");
                return 0;
            }
            return PortalCommand.createPortal(plr, args);
        }
        return 1;
    }

    private static Portal getPortalIgnoreCase(String name) {
        for (String s : KNOWN_PORTALS.keySet()) {
            if (!name.equalsIgnoreCase(s)) continue;
            return KNOWN_PORTALS.get(s);
        }
        return null;
    }

    private static int createPortal(ServerPlayer plr, String[] args) {
        Object[] poss = WandEventHandler.getWandPositionsOrNull(plr.getUUID());
        if (null == poss) {
            MultiworldMod.message((Player)plr, "You need to make an area selection first. (/mw portal wand)");
            return 0;
        }
        ServerLevel world = (ServerLevel)poss[0];
        BlockPos pos1 = (BlockPos)poss[1];
        BlockPos pos2 = (BlockPos)poss[2];
        if (null == world) {
            world = (ServerLevel)plr.level();
        }
        if (null == pos1 || null == pos2) {
            MultiworldMod.message((Player)plr, "Missing one position (/mw portal wand)");
            return 0;
        }
        String name = args[2];
        String nameL = name.toLowerCase(Locale.ROOT);
        String dest = args[3];
        if (KNOWN_PORTALS.containsKey(nameL)) {
            MultiworldMod.message((Player)plr, "&4A Portal with the name \"" + name + "\" already exists!");
            return 0;
        }
        Portal p = new Portal(name, plr.getName().getString(), world.dimension().location(), dest, pos1, pos2);
        p.buildPortalArea(pos1, pos2, world);
        KNOWN_PORTALS.put(nameL, p);
        try {
            p.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MultiworldMod.message((Player)plr, "&aPortal Created.");
        return 1;
    }

    public static void make_config(Portal p) {
        try {
            p.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void getSuggestions_PortalCommand(SuggestionsBuilder builder, String input, String[] cmds, CommandSourceStack plr, boolean ALL) {
        if (cmds.length <= 2 || cmds.length <= 3 && !input.endsWith(" ")) {
            for (String s : SUBCOMMANDS) {
                builder.suggest(s);
            }
            return;
        }
        String arg1 = cmds[2];
        if (cmds.length <= 3 || cmds.length <= 4 && !input.endsWith(" ")) {
            if (arg1.equalsIgnoreCase("create")) {
                builder.suggest("myPortalName");
                return;
            }
            if (arg1.equalsIgnoreCase("info") || arg1.equalsIgnoreCase("select") || arg1.equalsIgnoreCase("remove") || arg1.equalsIgnoreCase("refresh")) {
                for (Portal p : KNOWN_PORTALS.values()) {
                    builder.suggest(p.getName());
                }
            }
            return;
        }
        if (cmds.length <= 4 || cmds.length <= 5 && !input.endsWith(" ")) {
            if (arg1.equalsIgnoreCase("create")) {
                for (String s : InfoSuggest.getWorldNames()) {
                    builder.suggest(s);
                }
                for (Portal p : KNOWN_PORTALS.values()) {
                    builder.suggest("p:" + p.getName());
                }
                Vec3 pos = plr.getPosition();
                ServerLevel w = plr.getLevel();
                ResourceLocation id = w.dimension().location();
                String loc = PortalCommand.round(pos.x()) + "," + PortalCommand.round(pos.y()) + "," + PortalCommand.round(pos.z());
                builder.suggest("e:" + String.valueOf(id) + ":" + loc);
                return;
            }
            return;
        }
    }

    private static double round(double d) {
        return (double)Math.round(d * 100.0) / 100.0;
    }
}

