/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.multiworld.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import me.isaiah.multiworld.I18n;
import me.isaiah.multiworld.MultiworldMod;
import me.isaiah.multiworld.command.PortalCommand;
import me.isaiah.multiworld.neoforge.NeoForgeWorldCreator;
import me.isaiah.multiworld.neoforge.PermForge;
import me.isaiah.multiworld.portal.Portal;
import me.isaiah.multiworld.portal.WandEventHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import xyz.nucleoid.fantasy.FantasyInitializer;

@Mod(value="multiworld")
public class MultiworldModNeoForge {
    public static MyPostDimensionTransition NO_OP = new MyPostDimensionTransition();

    public MultiworldModNeoForge(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        new FantasyInitializer(modEventBus);
        NeoForgeWorldCreator.init();
        PermForge.init();
        MultiworldMod.init();
    }

    public void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        MultiworldMod.on_server_started(event.getServer());
    }

    @SubscribeEvent
    public void onCommandsRegister(RegisterCommandsEvent event) {
        MultiworldMod.register_commands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        WandEventHandler.leftClickBlock(event.getEntity(), event.getLevel(), event.getPos());
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        WandEventHandler.rightClickBlock(event.getEntity(), event.getLevel(), event.getHitVec());
    }

    @SubscribeEvent
    public void myEntityTravel(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        I18n.message((ServerPlayer)event.getEntity(), "EntityTravelToDimensionEvent");
        I18n.message((ServerPlayer)event.getEntity(), "KP: " + String.valueOf(PortalCommand.KNOWN_PORTALS.values()));
    }

    public static void onEntityTravel(EntityTravelToDimensionEvent event, ServerPlayer plr) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        BlockPos pos = player.blockPosition();
        BlockPos currentPos = player.blockPosition();
        for (Portal p : PortalCommand.KNOWN_PORTALS.values()) {
            BlockPos min = p.getMinPos();
            BlockPos max = p.getMaxPos();
            boolean isInside = pos.getX() >= min.getX() && pos.getX() <= max.getX() && pos.getY() >= min.getY() && pos.getY() <= max.getY() && pos.getZ() >= min.getZ() && pos.getZ() <= max.getZ();
            if (!isInside) continue;
            I18n.message(player, "&6Teleporting...");
            BlockPos dest = p.getDestLocation();
            event.setCanceled(true);
            MultiworldModNeoForge.teleleport(player, p.getDestWorld(), dest.getX(), dest.getY(), dest.getZ());
            return;
        }
    }

    public static void teleleport(ServerPlayer player, ServerLevel world, double x, double y, double z) {
        TeleportTransition target = new TeleportTransition(world, new Vec3(x, y, z), new Vec3(0.0, 0.0, 0.0), 0.0f, 0.0f, (TeleportTransition.PostTeleportTransition)NO_OP);
        player.teleport(target);
    }

    public static class MyPostDimensionTransition
    implements TeleportTransition.PostTeleportTransition {
        public void onTransition(Entity entity) {
            TeleportTransition.DO_NOTHING.onTransition(entity);
        }
    }
}

