/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.multiworld.portal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.regex.Pattern;
import me.isaiah.multiworld.MultiworldMod;
import me.isaiah.multiworld.command.PortalCommand;
import me.isaiah.multiworld.command.SpawnCommand;
import me.isaiah.multiworld.config.FileConfiguration;
import me.isaiah.multiworld.portal.PortalUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class Portal {
    private String name;
    private String owner;
    private ResourceLocation worldIn;
    private BlockPos minEdge;
    private BlockPos maxEdge;
    private String destination;
    private BlockPos destPos;

    private Portal(String name, String owner, ResourceLocation worldId, String destination) {
        this.name = name;
        this.owner = owner;
        this.worldIn = worldId;
        this.destination = destination;
    }

    public Portal(String name, String owner, ResourceLocation worldId, String destination, BlockPos a, BlockPos b) {
        this(name, owner, worldId, destination);
        this.minEdge = PortalUtil.getMinPos(a, b);
        this.maxEdge = PortalUtil.getMaxPos(a, b);
    }

    public Portal(String name, String owner, ResourceLocation worldId, String destination, String location) {
        this(name, owner, worldId, destination);
        try {
            this.locationFromString(location);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            MultiworldMod.LOGGER.info("Oops!");
            e.printStackTrace();
        }
    }

    public BlockPos getMinPos() {
        return this.minEdge;
    }

    public BlockPos getMaxPos() {
        return this.maxEdge;
    }

    public int getMaxY(int offset) {
        if (this.minEdge.getY() > this.maxEdge.getY()) {
            return this.minEdge.getY();
        }
        return this.maxEdge.getY() + offset;
    }

    public BlockPos getCenterExit() {
        return PortalUtil.getCenterWithLowestY(this.minEdge, this.maxEdge, 0);
    }

    private void locationFromString(String s) {
        String[] spl = s.split(Pattern.quote(":"));
        String[] from = spl[0].split(Pattern.quote(","));
        String[] to = spl[1].split(Pattern.quote(","));
        double x1 = Double.valueOf(from[0]);
        double y1 = Double.valueOf(from[1]);
        double z1 = Double.valueOf(from[2]);
        double x2 = Double.valueOf(to[0]);
        double y2 = Double.valueOf(to[1]);
        double z2 = Double.valueOf(to[2]);
        BlockPos a = MultiworldMod.get_world_creator().get_pos(x1, y1, z1);
        BlockPos b = MultiworldMod.get_world_creator().get_pos(x2, y2, z2);
        this.minEdge = PortalUtil.getMinPos(a, b);
        this.maxEdge = PortalUtil.getMaxPos(a, b);
    }

    public void addToMap() {
    }

    public static int reinit_portals_from_config(MinecraftServer mc) {
        File config_dir = new File("config");
        config_dir.mkdirs();
        File cf = new File(config_dir, "multiworld");
        cf.mkdirs();
        File wc = new File(cf, "portals.yml");
        try {
            if (!wc.exists()) {
                wc.createNewFile();
                return 0;
            }
            FileConfiguration config = new FileConfiguration(wc);
            if (!config.hasSection("portals")) {
                MultiworldMod.LOGGER.info("No save portals to load");
                return 0;
            }
            LinkedHashMap<String, Object> sect = config.getSection("portals");
            Set<String> keys = sect.keySet();
            int loaded = 0;
            for (String name : keys) {
                String prefix = "portals." + name;
                String owner = config.getString(prefix + ".owner");
                String location = config.getString(prefix + ".location");
                String world = config.getString(prefix + ".world");
                String dest = config.getString(prefix + ".destination");
                ResourceLocation worldIn = MultiworldMod.new_id(world);
                Portal p = new Portal(name, owner, worldIn, dest, location);
                p.buildPortalArea(p.getMinPos(), p.getMaxPos(), p.getOriginWorld());
                PortalCommand.addKnownPortal(name, p);
                ++loaded;
            }
            return loaded;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void save() throws IOException {
        File config_dir = new File("config");
        config_dir.mkdirs();
        File cf = new File(config_dir, "multiworld");
        cf.mkdirs();
        String name = this.getName();
        String prefix = "portals." + name;
        File wc = new File(cf, "portals.yml");
        if (!wc.exists()) {
            wc.createNewFile();
        }
        FileConfiguration config = new FileConfiguration(wc);
        config.set(prefix + ".entryfee.amount", 0.0);
        config.set(prefix + ".safeteleport", true);
        config.set(prefix + ".teleportnonplayers", false);
        config.set(prefix + ".handlerscript", "''");
        config.set(prefix + ".owner", this.getOwner());
        config.set(prefix + ".location", this.getLocationConfigString());
        config.set(prefix + ".world", this.getOriginWorldId());
        config.set(prefix + ".destination", this.getDestination());
        config.save();
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation getOriginWorldId() {
        return this.worldIn;
    }

    public BlockPos getDestLocation() {
        if (null == this.destPos) {
            return this.findDestPos();
        }
        return this.destPos;
    }

    public String getLocationConfigString() {
        return this.minEdge.getX() + "," + this.minEdge.getY() + "," + this.minEdge.getZ() + ":" + this.maxEdge.getX() + "," + this.maxEdge.getY() + "," + this.maxEdge.getZ();
    }

    public String getOwner() {
        return this.owner;
    }

    public String getDestination() {
        return this.destination;
    }

    public BlockPos findDestPos() {
        Portal pp;
        String name = this.getDestination();
        String[] spl = name.split(Pattern.quote(":"));
        String start = spl[0];
        if (start.length() > 1) {
            return SpawnCommand.getSpawn(this.getDestWorld());
        }
        if (start.equalsIgnoreCase("w")) {
            return SpawnCommand.getSpawn(this.getDestWorld());
        }
        if (start.equalsIgnoreCase("p") && null != (pp = PortalCommand.getKnownPortal(name.split(Pattern.quote("p:"))[1]))) {
            Direction.Axis axis = Math.abs(pp.getMinPos().getX() - this.getMaxPos().getX()) > Math.abs(this.getMinPos().getZ() - this.getMaxPos().getZ()) ? Direction.Axis.X : Direction.Axis.Z;
            BlockPos cen = PortalUtil.findSafeExit(pp.getDestWorld(), pp.getCenterExit(), 2, this.getMaxY(4));
            cen = axis == Direction.Axis.X ? cen.offset(0, 0, 2) : cen.offset(3, 0, 0);
            return cen;
        }
        if (start.equalsIgnoreCase("e")) {
            for (int i = 0; i < spl.length; ++i) {
                String vall = spl[i];
                if (vall.indexOf(44) == -1) continue;
                if (vall.split(Pattern.quote(",")).length != 3) {
                    return SpawnCommand.getSpawn(this.getDestWorld());
                }
                BlockPos pos = PortalUtil.blockPosFrom(vall);
                return pos;
            }
        }
        if (start.equalsIgnoreCase("a")) {
            // empty if block
        }
        return SpawnCommand.getSpawn(this.getDestWorld());
    }

    public String getDestWorldName() {
        Portal pp;
        Object name = this.getDestination();
        if (((String)name).startsWith("p:") && null != (pp = PortalCommand.getKnownPortal(((String)name).split(Pattern.quote("p:"))[1]))) {
            return pp.getOriginWorldId().toString();
        }
        if (((String)name).startsWith("e:")) {
            name = PortalUtil.extractIdentifier((String)name);
        }
        if (((String)name).indexOf(58) == -1) {
            name = "multiworld:" + (String)name;
        }
        return name;
    }

    public ServerLevel getDestWorld() {
        Portal pp;
        Object name = this.getDestination();
        if (((String)name).startsWith("p:") && null != (pp = PortalCommand.getKnownPortal(((String)name).split(Pattern.quote("p:"))[1]))) {
            return pp.getOriginWorld();
        }
        if (((String)name).startsWith("e:")) {
            name = PortalUtil.extractIdentifier((String)name);
        }
        if (((String)name).indexOf(58) == -1) {
            name = "multiworld:" + (String)name;
        }
        HashMap worlds = new HashMap();
        MultiworldMod.mc.levelKeys().forEach(r -> {
            ServerLevel world = MultiworldMod.mc.getLevel(r);
            worlds.put(r.location().toString(), world);
        });
        ServerLevel w = (ServerLevel)worlds.get(name);
        return w;
    }

    public ServerLevel getOriginWorld() {
        String name = this.getOriginWorldId().toString();
        HashMap worlds = new HashMap();
        MultiworldMod.mc.levelKeys().forEach(r -> {
            ServerLevel world = MultiworldMod.mc.getLevel(r);
            worlds.put(r.location().toString(), world);
        });
        ServerLevel w = (ServerLevel)worlds.get(name);
        return w;
    }

    @Deprecated
    public void fillBlocks(BlockPos pos, ServerLevel w) {
        BlockPos pos2;
        int y;
        int x;
        for (x = 0; x < 4; ++x) {
            for (y = 0; y < 5; ++y) {
                if (x != 0 && x != 3 && y != 0 && y != 4) continue;
                pos2 = pos.offset(x, y, 0);
                w.setBlockAndUpdate(pos2, Blocks.STONE.defaultBlockState());
            }
        }
        for (x = 1; x < 3; ++x) {
            for (y = 1; y < 4; ++y) {
                pos2 = pos.offset(x, y, 0);
                w.setBlockAndUpdate(pos2, Blocks.NETHER_PORTAL.defaultBlockState());
            }
        }
    }

    public void refreshPortalArea() {
        this.buildPortalArea(this.getMinPos(), this.getMaxPos(), this.getOriginWorld());
    }

    public void buildPortalArea(BlockPos pos1, BlockPos pos2, ServerLevel world) {
        int minX = Math.min(pos1.getX(), pos2.getX());
        int minY = Math.min(pos1.getY(), pos2.getY());
        int minZ = Math.min(pos1.getZ(), pos2.getZ());
        int maxX = Math.max(pos1.getX(), pos2.getX());
        int maxY = Math.max(pos1.getY(), pos2.getY());
        int maxZ = Math.max(pos1.getZ(), pos2.getZ());
        ArrayList<BlockPos> innerBlocks = new ArrayList<BlockPos>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    boolean isOnEdge;
                    BlockPos currentPos = new BlockPos(x, y, z);
                    int edgeCount = 0;
                    if (x == minX || x == maxX) {
                        ++edgeCount;
                    }
                    if (y == minY || y == maxY) {
                        ++edgeCount;
                    }
                    if (z == minZ || z == maxZ) {
                        ++edgeCount;
                    }
                    boolean bl = isOnEdge = edgeCount >= 2;
                    if (isOnEdge) {
                        if (!world.isEmptyBlock(currentPos)) continue;
                        world.setBlockAndUpdate(currentPos, Blocks.OBSIDIAN.defaultBlockState());
                        continue;
                    }
                    innerBlocks.add(currentPos);
                }
            }
        }
        Direction.Axis axis = Math.abs(pos1.getX() - pos2.getX()) > Math.abs(pos1.getZ() - pos2.getZ()) ? Direction.Axis.X : Direction.Axis.Z;
        for (BlockPos currentPos : innerBlocks) {
            BlockState portalState = (BlockState)Blocks.NETHER_PORTAL.defaultBlockState().setValue((Property)NetherPortalBlock.AXIS, (Comparable)axis);
            world.setBlockAndUpdate(currentPos, portalState);
        }
    }
}

