/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.multiworld.portal;

import java.util.HashMap;
import java.util.UUID;
import me.isaiah.multiworld.MultiworldMod;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class WandEventHandler {
    private static final HashMap<UUID, Object[]> playerPositions = new HashMap();
    private static final ItemStack wand = new ItemStack((ItemLike)Items.WOODEN_AXE);

    public static InteractionResult leftClickBlock(Player player, Level world, BlockPos pos) {
        if (!world.isClientSide && WandEventHandler.isHoldingWand(player)) {
            WandEventHandler.setPosition(player, pos, 1);
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult rightClickBlock(Player player, Level world, BlockHitResult hitResult) {
        if (!world.isClientSide && WandEventHandler.isHoldingWand(player)) {
            WandEventHandler.setPosition(player, hitResult.getBlockPos(), 2);
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public static ItemStack getItemStack() {
        return wand;
    }

    private static boolean isHoldingWand(Player player) {
        ItemStack held = player.getMainHandItem();
        return held.getItem() == wand.getItem();
    }

    private static void setPosition(Player player, BlockPos pos, int index) {
        UUID uuid = player.getUUID();
        Object[] positions = playerPositions.getOrDefault(uuid, new Object[3]);
        positions[index] = pos;
        playerPositions.put(uuid, positions);
        positions[0] = (ServerLevel)player.level();
        MultiworldMod.message(player, "&9[MultiworldPortals]&a\ud83d\udccd&r Position " + index + " set to: " + pos.toShortString());
    }

    public static Object[] getWandPositions(UUID playerId) {
        return playerPositions.getOrDefault(playerId, new Object[3]);
    }

    public static Object[] getWandPositionsOrNull(UUID playerId) {
        if (playerPositions.containsKey(playerId)) {
            return playerPositions.get(playerId);
        }
        return null;
    }
}

