/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.fantasy;

import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.WorldData;
import xyz.nucleoid.fantasy.RuntimeWorldConfig;

public final class RuntimeWorldProperties
extends DerivedLevelData {
    protected final RuntimeWorldConfig config;
    private final GameRules rules;

    public RuntimeWorldProperties(WorldData saveProperties, RuntimeWorldConfig config) {
        super(saveProperties, saveProperties.overworldData());
        this.config = config;
        this.rules = new GameRules(saveProperties.enabledFeatures());
        config.getGameRules().applyTo(this.rules, null);
    }

    public GameRules getGameRules() {
        return this.rules;
    }

    public void setDayTime(long timeOfDay) {
        this.config.setTimeOfDay(timeOfDay);
    }

    public long getDayTime() {
        return this.config.getTimeOfDay();
    }

    public void setClearWeatherTime(int time) {
        this.config.setSunny(time);
    }

    public int getClearWeatherTime() {
        return this.config.getSunnyTime();
    }

    public void setRaining(boolean raining) {
        this.config.setRaining(raining);
    }

    public boolean isRaining() {
        return this.config.isRaining();
    }

    public void setRainTime(int time) {
        this.config.setRaining(time);
    }

    public int getRainTime() {
        return this.config.getRainTime();
    }

    public void setThundering(boolean thundering) {
        this.config.setThundering(thundering);
    }

    public boolean isThundering() {
        return this.config.isThundering();
    }

    public void setThunderTime(int time) {
        this.config.setThundering(time);
    }

    public int getThunderTime() {
        return this.config.getThunderTime();
    }

    public Difficulty getDifficulty() {
        return this.config.getDifficulty();
    }
}

