/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.multiworld;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import me.isaiah.multiworld.MultiworldMod;
import me.isaiah.multiworld.command.CreateCommand;
import me.isaiah.multiworld.command.GameruleCommand;
import me.isaiah.multiworld.command.PortalCommand;
import me.isaiah.multiworld.perm.Perm;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ServerLevelData;

public class InfoSuggest
implements SuggestionProvider<CommandSourceStack> {
    public static String[] diff_names = new String[]{"PEACEFUL", "EASY", "NORMAL", "HARD"};
    private static String[] subcommands = new String[]{"tp", "list", "version", "create", "spawn", "setspawn", "gamerule", "help", "difficulty", "portal"};

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        builder = builder.createOffset(builder.getInput().lastIndexOf(32) + 1);
        String input = builder.getInput();
        String[] cmds = input.trim().split(" ");
        CommandSourceStack plr = (CommandSourceStack)context.getSource();
        boolean ALL = Perm.has(plr, "multiworld.admin");
        if (cmds.length <= 1 || cmds.length <= 2 && !input.endsWith(" ")) {
            for (String s : subcommands) {
                builder.suggest(s);
            }
            return builder.buildFuture();
        }
        if (cmds.length <= 2 || cmds.length <= 3 && !input.endsWith(" ")) {
            Object last;
            if (cmds[1].equalsIgnoreCase("tp") && (ALL || Perm.has(plr, "multiworld.tp"))) {
                MinecraftServer mc = MultiworldMod.mc;
                ArrayList names = new ArrayList();
                mc.m_129785_().forEach(world -> {
                    Object name = ((ServerLevelData)world.m_6106_()).m_5462_();
                    if (names.contains(name)) {
                        if (world.m_46472_() == Level.f_46429_) {
                            name = (String)name + "_nether";
                        }
                        if (world.m_46472_() == Level.f_46430_) {
                            name = (String)name + "_the_end";
                        }
                    }
                });
                mc.m_129784_().forEach(r -> {
                    String val = r.m_135782_().toString();
                    if (val.startsWith("multiworld:")) {
                        val = val.replace("multiworld:", "");
                    }
                    names.add(val);
                });
                for (String s : names) {
                    builder.suggest(s);
                }
            }
            if (cmds[1].equalsIgnoreCase("gamerule") && (ALL || Perm.has(plr, "multiworld.gamerule"))) {
                if (GameruleCommand.keys.size() == 0) {
                    GameruleCommand.setupServer(MultiworldMod.mc);
                }
                last = input.substring(input.lastIndexOf(32)).trim();
                for (String name : GameruleCommand.keys.keySet()) {
                    if (!name.startsWith((String)last) && !((String)last).contains("gamerule") && !name.toLowerCase().contains((CharSequence)last)) continue;
                    builder.suggest(name);
                }
                return builder.buildFuture();
            }
            if (cmds[1].equalsIgnoreCase("difficulty") && (ALL || Perm.has(plr, "multiworld.difficulty"))) {
                last = input.substring(input.lastIndexOf(32)).trim();
                for (String name : diff_names) {
                    if (!name.startsWith((String)last) && !((String)last).contains("difficulty") && !name.toLowerCase().contains((CharSequence)last)) continue;
                    builder.suggest(name);
                }
                return builder.buildFuture();
            }
            if (cmds[1].equalsIgnoreCase("portal")) {
                for (String s : PortalCommand.SUBCOMMANDS) {
                    builder.suggest(s);
                }
                return builder.buildFuture();
            }
        }
        if (cmds.length <= 3 || cmds.length <= 4 && !input.endsWith(" ")) {
            if (cmds[1].equalsIgnoreCase("gamerule") && (ALL || Perm.has(plr, "multiworld.gamerule"))) {
                builder.suggest("true");
                builder.suggest("false");
            }
            if (cmds[1].equalsIgnoreCase("difficulty") && (ALL || Perm.has(plr, "multiworld.difficulty"))) {
                ArrayList names = new ArrayList();
                MultiworldMod.mc.m_129784_().forEach(r -> {
                    String val = r.m_135782_().toString();
                    if (val.startsWith("multiworld:")) {
                        val = val.replace("multiworld:", "");
                    }
                    names.add(val);
                });
                for (String s : names) {
                    builder.suggest(s);
                }
            }
        }
        if (cmds[1].equalsIgnoreCase("create") && (ALL || Perm.has(plr, "multiworld.create"))) {
            this.getSuggestions_CreateCommand(builder, input, cmds, plr, ALL);
        }
        if (cmds[1].equalsIgnoreCase("portal")) {
            PortalCommand.getSuggestions_PortalCommand(builder, input, cmds, plr, ALL);
        }
        return builder.buildFuture();
    }

    public static List<String> getWorldNames() {
        MinecraftServer mc = MultiworldMod.mc;
        ArrayList<String> names = new ArrayList<String>();
        mc.m_129785_().forEach(world -> {
            Object name = ((ServerLevelData)world.m_6106_()).m_5462_();
            if (names.contains(name)) {
                if (world.m_46472_() == Level.f_46429_) {
                    name = (String)name + "_nether";
                }
                if (world.m_46472_() == Level.f_46430_) {
                    name = (String)name + "_the_end";
                }
            }
        });
        mc.m_129784_().forEach(r -> {
            String val = r.m_135782_().toString();
            if (val.startsWith("multiworld:")) {
                val = val.replace("multiworld:", "");
            }
            names.add(val);
        });
        return names;
    }

    public void getSuggestions_CreateCommand(SuggestionsBuilder builder, String input, String[] cmds, CommandSourceStack plr, boolean ALL) {
        if (!ALL && !Perm.has(plr, "multiworld.create")) {
            return;
        }
        if (cmds.length <= 2 || cmds.length <= 3 && !input.endsWith(" ")) {
            builder.suggest("myid:myvalue");
            return;
        }
        if (cmds.length <= 3 || cmds.length <= 4 && !input.endsWith(" ")) {
            builder.suggest("NORMAL");
            builder.suggest("NETHER");
            builder.suggest("END");
            return;
        }
        int maxDebug = 7;
        if (cmds.length <= 4 || cmds.length <= maxDebug && !input.endsWith(" ")) {
            if (cmds.length <= 4) {
                builder.suggest("-g=<GENERATOR>");
                builder.suggest("-s=<SEED>");
                return;
            }
            int n = 3;
            String current = cmds[cmds.length - 1];
            CharSequence[] beforeCurrent = Arrays.copyOfRange(cmds, n + 1, cmds.length - 1);
            String beforeStr = String.join((CharSequence)" ", beforeCurrent);
            if (current.startsWith("-s=")) {
                builder.suggest("-s=1234");
                builder.suggest("-s=RANDOM");
            } else if (current.startsWith("-g=")) {
                builder.suggest("-g=NORMAL");
                builder.suggest("-g=FLAT");
                builder.suggest("-g=VOID");
                for (String key : CreateCommand.customs.keySet()) {
                    builder.suggest("-g=" + key.toUpperCase(Locale.ROOT));
                }
            } else if (current.startsWith("-")) {
                if (!beforeStr.contains("-g=")) {
                    builder.suggest("-g=<GENERATOR>");
                }
                if (!beforeStr.contains("-s=")) {
                    builder.suggest("-s=<SEED>");
                }
            }
        }
    }
}

