/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.multiworld.command;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import me.isaiah.multiworld.I18n;
import me.isaiah.multiworld.MultiworldMod;
import me.isaiah.multiworld.command.Command;
import me.isaiah.multiworld.command.GameruleCommand;
import me.isaiah.multiworld.command.Util;
import me.isaiah.multiworld.config.FileConfiguration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateCommand
implements Command {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"multiworld");
    public static HashMap<String, ChunkGenerator> customs = new HashMap();

    public static void registerCustomGenerator(ResourceLocation id, ChunkGenerator gen) {
        customs.put(id.toString().toLowerCase(Locale.ROOT), gen);
    }

    private static Tuple<ChunkGenerator, String> checkArgForGen(MinecraftServer mc, String arg) {
        if (arg.startsWith("-g ") || arg.startsWith("-g=")) {
            String ab = arg.substring("-g=".length());
            ChunkGenerator gen1 = CreateCommand.get_chunk_gen(mc, ab);
            if (null != gen1) {
                return new Tuple<ChunkGenerator, String>(gen1, ab);
            }
            return new Tuple<Object, String>(null, ab);
        }
        return null;
    }

    private static Optional<Long> checkArgForSeed(MinecraftServer mc, String arg) {
        if (arg.startsWith("-s ") || arg.startsWith("-s=")) {
            String ab = arg.substring("-s=".length());
            if (ab.startsWith("RANDOM")) {
                return Optional.empty();
            }
            try {
                Long f = Long.parseLong(ab);
                return Optional.of(f);
            }
            catch (NumberFormatException e) {
                Long seed = ab.hashCode();
                return Optional.of(seed);
            }
        }
        return Optional.empty();
    }

    public static int run(MinecraftServer mc, ServerPlayer plr, String[] args) {
        Object arg1;
        if (args.length == 1 || args.length == 2) {
            I18n.message(plr, "Usage: /mv create <id> <env> [-g=<gen> -s=<seed>]");
            return 0;
        }
        Random r = new Random();
        long seed = r.nextInt();
        String env = args[2];
        ChunkGenerator gen = CreateCommand.get_chunk_gen(mc, env);
        ResourceLocation dim = CreateCommand.get_dim_id(env);
        if (null == dim) {
            System.out.println("Null dimenstion ");
            dim = Util.OVERWORLD_ID;
        }
        if (((String)(arg1 = args[1])).indexOf(58) == -1) {
            arg1 = "multiworld:" + (String)arg1;
        }
        String customGen = "";
        if (args.length > 3) {
            for (int i = 3; i < args.length; ++i) {
                Optional<Long> resultB;
                String arg = args[i];
                Tuple<ChunkGenerator, String> resultA = CreateCommand.checkArgForGen(mc, arg);
                if (null != resultA) {
                    if (null != resultA.first) {
                        gen = (ChunkGenerator)resultA.first;
                        customGen = (String)resultA.second;
                        MultiworldMod.message((Player)plr, "Using ChunkGenerator: \"" + customGen + "\".");
                    } else {
                        MultiworldMod.message((Player)plr, "&4Invalid ChunkGenerator: \"" + (String)resultA.second + "\"");
                    }
                }
                if (!(resultB = CreateCommand.checkArgForSeed(mc, arg)).isPresent()) continue;
                MultiworldMod.message((Player)plr, "Using seed \"" + String.valueOf(resultB.get()) + "\".");
                seed = resultB.get();
            }
        }
        ServerLevel world = MultiworldMod.create_world((String)arg1, dim, gen, Difficulty.NORMAL, seed);
        CreateCommand.make_config(world, args[2], seed, customGen);
        MultiworldMod.message((Player)plr, "&aCreated world with id: " + args[1]);
        return 1;
    }

    public static ResourceLocation get_dim_id(String env) {
        if (env.contains("NORMAL")) {
            return Util.OVERWORLD_ID;
        }
        if (env.contains("NETHER")) {
            return Util.THE_NETHER_ID;
        }
        if (env.contains("END")) {
            return Util.THE_END_ID;
        }
        if (customs.containsKey(env)) {
            return MultiworldMod.new_id(env);
        }
        if (customs.containsKey(env.toLowerCase(Util.AMERICAN_STANDARD))) {
            return MultiworldMod.new_id(env);
        }
        if (customs.containsKey(env.toUpperCase(Util.AMERICAN_STANDARD))) {
            return MultiworldMod.new_id(env);
        }
        return null;
    }

    public static ChunkGenerator get_chunk_gen(MinecraftServer mc, String env) {
        ChunkGenerator gen = MultiworldMod.get_world_creator().get_chunk_gen(mc, env.toUpperCase(Locale.ROOT));
        if (customs.containsKey(env)) {
            return customs.get(env);
        }
        if (customs.containsKey(env.toLowerCase(Util.AMERICAN_STANDARD))) {
            return customs.get(env.toLowerCase(Util.AMERICAN_STANDARD));
        }
        if (customs.containsKey(env.toUpperCase(Util.AMERICAN_STANDARD))) {
            return customs.get(env.toUpperCase(Util.AMERICAN_STANDARD));
        }
        return gen;
    }

    public static void reinit_world_from_config(MinecraftServer mc, String id) {
        File config_dir = new File("config");
        config_dir.mkdirs();
        String[] spl = id.split(":");
        File cf = new File(config_dir, "multiworld");
        cf.mkdirs();
        File worlds = new File(cf, "worlds");
        worlds.mkdirs();
        File namespace = new File(worlds, spl[0]);
        namespace.mkdirs();
        File wc = new File(namespace, spl[1] + ".yml");
        try {
            if (!wc.exists()) {
                wc.createNewFile();
            }
            FileConfiguration config = new FileConfiguration(wc);
            String env = config.getString("environment");
            long seed = 0L;
            try {
                seed = config.getLong("seed");
            }
            catch (Exception e) {
                seed = config.getInt("seed");
            }
            ChunkGenerator gen = CreateCommand.get_chunk_gen(mc, env);
            ResourceLocation dim = CreateCommand.get_dim_id(env);
            if (null == dim) {
                dim = Util.OVERWORLD_ID;
            }
            Difficulty d = Difficulty.NORMAL;
            if (config.is_set("difficulty")) {
                String di = config.getString("difficulty");
                if (di.equalsIgnoreCase("EASY")) {
                    d = Difficulty.EASY;
                }
                if (di.equalsIgnoreCase("HARD")) {
                    d = Difficulty.HARD;
                }
                if (di.equalsIgnoreCase("NORMAL")) {
                    d = Difficulty.NORMAL;
                }
                if (di.equalsIgnoreCase("PEACEFUL")) {
                    d = Difficulty.PEACEFUL;
                }
            }
            if (config.is_set("custom_generator")) {
                String cg = config.getString("custom_generator");
                ChunkGenerator gen1 = CreateCommand.get_chunk_gen(mc, cg);
                if (null != gen1) {
                    gen = gen1;
                } else {
                    System.out.println("Invalid ChunkGenerator: \"" + cg + "\"");
                }
            }
            ServerLevel world = MultiworldMod.create_world(id, dim, gen, d, seed);
            MultiworldMod.get_world_creator().set_difficulty(id, d);
            if (GameruleCommand.keys.size() == 0) {
                GameruleCommand.setupServer(MultiworldMod.mc);
            }
            for (String name : GameruleCommand.keys.keySet()) {
                String key = "gamerule_" + name;
                if (!config.is_set(key)) continue;
                Object o = config.getObject(key);
                if (o instanceof Boolean) {
                    Object object = o = (Boolean)o != false ? "true" : "false";
                }
                if (o instanceof Integer) {
                    o = String.valueOf((Integer)o);
                }
                GameruleCommand.set_gamerule_from_cfg(world, key, (String)o);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void make_config(ServerLevel w, String dim, long seed, String cgen) {
        File config_dir = new File("config");
        config_dir.mkdirs();
        File cf = new File(config_dir, "multiworld");
        cf.mkdirs();
        File worlds = new File(cf, "worlds");
        worlds.mkdirs();
        ResourceLocation id = w.m_46472_().m_135782_();
        File namespace = new File(worlds, id.m_135827_());
        namespace.mkdirs();
        File wc = new File(namespace, id.m_135815_() + ".yml");
        try {
            if (!wc.exists()) {
                wc.createNewFile();
            }
            FileConfiguration config = new FileConfiguration(wc);
            config.set("namespace", id.m_135827_());
            config.set("path", id.m_135815_());
            config.set("environment", dim);
            config.set("seed", seed);
            if (null != cgen && cgen.length() > 0) {
                config.set("custom_generator", cgen);
            }
            config.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class Tuple<K, V> {
        private K first;
        private V second;

        public Tuple(K first, V second) {
            this.first = first;
            this.second = second;
        }
    }
}

