/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.multiworld.command;

import java.io.File;
import java.util.HashMap;
import me.isaiah.multiworld.I18n;
import me.isaiah.multiworld.MultiworldMod;
import me.isaiah.multiworld.command.Command;
import me.isaiah.multiworld.command.SpawnCommand;
import me.isaiah.multiworld.config.FileConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Blocks;

public class TpCommand
implements Command {
    public static int run(MinecraftServer mc, ServerPlayer plr, String[] args) {
        HashMap worlds = new HashMap();
        mc.m_129784_().forEach(r -> {
            ServerLevel world = mc.m_129880_(r);
            worlds.put(r.m_135782_().toString(), world);
        });
        Object arg1 = args[1];
        if (((String)arg1).indexOf(58) == -1) {
            arg1 = "multiworld:" + (String)arg1;
        }
        if (null == plr) {
            if (args.length <= 2) {
                return 0;
            }
            String target = args[2];
            plr = mc.m_6846_().m_11255_(target);
        }
        if (worlds.containsKey(arg1)) {
            ServerLevel w = (ServerLevel)worlds.get(arg1);
            BlockPos sp = SpawnCommand.getSpawn(w);
            boolean isEnd = false;
            try {
                boolean is_the_end = MultiworldMod.get_world_creator().is_the_end(w);
                if (is_the_end) {
                    isEnd = true;
                }
            }
            catch (Exception | NoSuchMethodError is_the_end) {
                // empty catch block
            }
            String env = TpCommand.read_env_from_config((String)arg1);
            if (null != env && env.equalsIgnoreCase("END")) {
                isEnd = true;
            }
            if (isEnd) {
                TpCommand.method_29200_createEndSpawnPlatform(w);
                sp = ServerLevel.f_8562_;
            }
            if (null == sp) {
                I18n.message(plr, "&4Error: null getSpawnPos");
                sp = new BlockPos(1, 40, 1);
            }
            I18n.message(plr, "&6Teleporting...");
            sp = TpCommand.findSafePos(w, sp);
            MultiworldMod.get_world_creator().teleleport(plr, w, sp.m_123341_(), sp.m_123342_(), sp.m_123343_());
            return 1;
        }
        return 1;
    }

    public static void method_29200_createEndSpawnPlatform(ServerLevel world) {
        BlockPos lv = ServerLevel.f_8562_;
        int i = lv.m_123341_();
        int j = lv.m_123342_() - 2;
        int k = lv.m_123343_();
        BlockPos.m_121976_((int)(i - 2), (int)(j + 1), (int)(k - 2), (int)(i + 2), (int)(j + 3), (int)(k + 2)).forEach(pos -> world.m_46597_(pos, Blocks.f_50016_.m_49966_()));
        BlockPos.m_121976_((int)(i - 2), (int)j, (int)(k - 2), (int)(i + 2), (int)j, (int)(k + 2)).forEach(pos -> world.m_46597_(pos, Blocks.f_50080_.m_49966_()));
    }

    private static BlockPos findSafePos(ServerLevel w, BlockPos sp) {
        BlockPos pos = sp;
        while (w.m_8055_(pos) != Blocks.f_50016_.m_49966_()) {
            pos = pos.m_7918_(0, 1, 0);
        }
        return pos;
    }

    public static BlockPos multiworld_method_43126(ServerLevel world) {
        return SpawnCommand.multiworld_method_43126(world);
    }

    public static String read_env_from_config(String id) {
        File config_dir = new File("config");
        config_dir.mkdirs();
        String[] spl = id.split(":");
        File cf = new File(config_dir, "multiworld");
        cf.mkdirs();
        File worlds = new File(cf, "worlds");
        worlds.mkdirs();
        File namespace = new File(worlds, spl[0]);
        namespace.mkdirs();
        File wc = new File(namespace, spl[1] + ".yml");
        try {
            if (!wc.exists()) {
                wc.createNewFile();
            }
            FileConfiguration config = new FileConfiguration(wc);
            String env = config.getString("environment");
            return env;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "NORMAL";
        }
    }
}

