/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.multiworld.forge;

import dimapi.FabricDimensionInternals;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import me.isaiah.multiworld.ICreator;
import me.isaiah.multiworld.MultiworldMod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.Vec3;
import xyz.nucleoid.fantasy.Fantasy;
import xyz.nucleoid.fantasy.RuntimeWorldConfig;
import xyz.nucleoid.fantasy.RuntimeWorldHandle;

public class ForgeWorldCreator
implements ICreator {
    public HashMap<String, RuntimeWorldConfig> worldConfigs = new HashMap();

    public static void init() {
        MultiworldMod.setICreator(new ForgeWorldCreator());
    }

    @Override
    public ServerLevel create_world(String id, ResourceLocation dim, ChunkGenerator gen, Difficulty dif, long seed) {
        RuntimeWorldConfig config = new RuntimeWorldConfig().setDimensionType(ForgeWorldCreator.dim_of(dim)).setGenerator(gen).setDifficulty(dif).setSeed(seed).setShouldTickTime(true);
        Fantasy fantasy = Fantasy.get(MultiworldMod.mc);
        RuntimeWorldHandle worldHandle = fantasy.getOrOpenPersistentWorld(new ResourceLocation(id), config);
        this.worldConfigs.put(id, config);
        return worldHandle.asWorld();
    }

    @Override
    public void set_difficulty(String id, Difficulty dif) {
        this.worldConfigs.get(id).setDifficulty(dif);
    }

    private static ResourceKey<DimensionType> dim_of(ResourceLocation id) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)id);
    }

    @Override
    public void delete_world(String id) {
        Fantasy fantasy = Fantasy.get(MultiworldMod.mc);
        RuntimeWorldHandle worldHandle = fantasy.getOrOpenPersistentWorld(new ResourceLocation(id), null);
        worldHandle.delete();
    }

    @Override
    public boolean is_the_end(ServerLevel world) {
        return world.m_220362_() == BuiltinDimensionTypes.f_223540_;
    }

    @Override
    public BlockPos get_pos(double x, double y, double z) {
        return BlockPos.m_274561_((double)x, (double)y, (double)z);
    }

    @Override
    public BlockPos get_spawn(ServerLevel world) {
        LevelData prop = world.m_6106_();
        return new BlockPos(prop.m_6789_(), prop.m_6527_(), prop.m_6526_());
    }

    @Override
    public void teleleport(ServerPlayer player, ServerLevel world, double x, double y, double z) {
        PortalInfo target = new PortalInfo(new Vec3(x, y, z), new Vec3(0.0, 0.0, 0.0), 0.0f, 0.0f);
        FabricDimensionInternals.changeDimension(player, world, target);
    }

    @Override
    public ChunkGenerator get_flat_chunk_gen(MinecraftServer mc) {
        Holder biome = mc.m_206579_().m_175515_(Registries.f_256952_).m_263177_((Object)((Biome)mc.m_206579_().m_175515_(Registries.f_256952_).m_123013_(Biomes.f_48202_)));
        FlatLevelGeneratorSettings flat = new FlatLevelGeneratorSettings(Optional.empty(), biome, Collections.emptyList());
        CustomFlatChunkGenerator generator = new CustomFlatChunkGenerator(flat);
        return generator;
    }

    @Override
    public ChunkGenerator get_void_chunk_gen(MinecraftServer mc) {
        return this.get_flat_chunk_gen(mc);
    }

    class CustomFlatChunkGenerator
    extends FlatLevelSource {
        public CustomFlatChunkGenerator(FlatLevelGeneratorSettings config) {
            super(config);
        }

        public int m_142062_() {
            return 0;
        }

        public int m_6337_() {
            return 0;
        }
    }
}

