/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.multiworld.portal;

import java.util.StringJoiner;
import java.util.regex.Pattern;
import me.isaiah.multiworld.MultiworldMod;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class PortalUtil {
    public static String extractIdentifier(String input) {
        if (!input.startsWith("e:")) {
            return input;
        }
        String trimmed = input.substring(2);
        String[] parts = trimmed.split(":");
        int removeCount = 0;
        for (int i = parts.length - 1; i >= 0 && removeCount < 2; --i) {
            if (!parts[i].contains(",")) continue;
            ++removeCount;
        }
        StringJoiner joiner = new StringJoiner(":");
        for (int i = 0; i < parts.length - removeCount; ++i) {
            joiner.add(parts[i]);
        }
        return joiner.toString();
    }

    public static BlockPos findSafeExit(ServerLevel world, BlockPos origin, int radius, int maxY) {
        for (int y = origin.m_123342_(); y < maxY; ++y) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    boolean isSafe;
                    BlockPos checkPos = origin.m_7918_(dx, y - origin.m_123342_(), dz);
                    BlockState floor = world.m_8055_(checkPos);
                    BlockState head = world.m_8055_(checkPos.m_7494_());
                    BlockState aboveHead = world.m_8055_(checkPos.m_6630_(2));
                    boolean bl = isSafe = floor.m_60796_((BlockGetter)world, checkPos) && head.m_60795_() && aboveHead.m_60795_();
                    if (!isSafe) continue;
                    return checkPos.m_7494_();
                }
            }
        }
        return origin;
    }

    public static BlockPos getCenterWithLowestY(BlockPos pos1, BlockPos pos2, int yOffset) {
        int centerX = (pos1.m_123341_() + pos2.m_123341_()) / 2;
        int centerZ = (pos1.m_123343_() + pos2.m_123343_()) / 2;
        int lowestY = Math.min(pos1.m_123342_(), pos2.m_123342_()) + yOffset;
        return new BlockPos(centerX, lowestY, centerZ);
    }

    public static BlockPos getMinPos(BlockPos a, BlockPos b) {
        return new BlockPos(Math.min(a.m_123341_(), b.m_123341_()), Math.min(a.m_123342_(), b.m_123342_()), Math.min(a.m_123343_(), b.m_123343_()));
    }

    public static BlockPos getMaxPos(BlockPos a, BlockPos b) {
        return new BlockPos(Math.max(a.m_123341_(), b.m_123341_()), Math.max(a.m_123342_(), b.m_123342_()), Math.max(a.m_123343_(), b.m_123343_()));
    }

    public static BlockPos blockPosFrom(String line) {
        String[] from = line.split(Pattern.quote(","));
        double x1 = Double.valueOf(from[0]);
        double y1 = Double.valueOf(from[1]);
        double z1 = Double.valueOf(from[2]);
        BlockPos a = MultiworldMod.get_world_creator().get_pos(x1, y1, z1);
        return a;
    }
}

