/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.fantasy;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.nucleoid.fantasy.RuntimeWorld;
import xyz.nucleoid.fantasy.RuntimeWorldConfig;
import xyz.nucleoid.fantasy.RuntimeWorldHandle;
import xyz.nucleoid.fantasy.RuntimeWorldManager;
import xyz.nucleoid.fantasy.mixin.MinecraftServerAccess;

public final class Fantasy {
    public static final Logger LOGGER = LogManager.getLogger(Fantasy.class);
    public static final String ID = "fantasy";
    public static final ResourceKey<DimensionType> DEFAULT_DIM_TYPE = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)new ResourceLocation("fantasy", "default"));
    private static Fantasy instance;
    private final MinecraftServer server;
    private final MinecraftServerAccess serverAccess;
    public final RuntimeWorldManager worldManager;
    private final Set<ServerLevel> deletionQueue = new ReferenceOpenHashSet();

    private Fantasy(MinecraftServer server) {
        this.server = server;
        this.serverAccess = (MinecraftServerAccess)server;
        this.worldManager = new RuntimeWorldManager(server);
    }

    public static Fantasy get(MinecraftServer server) {
        Preconditions.checkState((boolean)server.m_18695_(), (Object)"cannot create worlds from off-thread!");
        if (instance == null || Fantasy.instance.server != server) {
            instance = new Fantasy(server);
        }
        return instance;
    }

    public void tick() {
        Set<ServerLevel> deletionQueue = this.deletionQueue;
        if (!deletionQueue.isEmpty()) {
            deletionQueue.removeIf(this::tickDeleteWorld);
        }
    }

    public RuntimeWorldHandle openTemporaryWorld(RuntimeWorldConfig config) {
        RuntimeWorld world = this.addTemporaryWorld(config);
        return new RuntimeWorldHandle(this, world);
    }

    public RuntimeWorldHandle getOrOpenPersistentWorld(ResourceLocation key, RuntimeWorldConfig config) {
        ResourceKey worldKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)key);
        ServerLevel world = this.server.m_129880_(worldKey);
        if (world == null) {
            world = this.addPersistentWorld(key, config);
        } else {
            this.deletionQueue.remove(world);
        }
        return new RuntimeWorldHandle(this, world);
    }

    private RuntimeWorld addPersistentWorld(ResourceLocation key, RuntimeWorldConfig config) {
        ResourceKey worldKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)key);
        return this.worldManager.add((ResourceKey<Level>)worldKey, config, RuntimeWorld.Style.PERSISTENT);
    }

    private RuntimeWorld addTemporaryWorld(RuntimeWorldConfig config) {
        ResourceKey worldKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)Fantasy.generateTemporaryWorldKey());
        try {
            LevelStorageSource.LevelStorageAccess session = this.serverAccess.getSession();
            FileUtils.forceDeleteOnExit((File)session.m_197394_(worldKey).toFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.worldManager.add((ResourceKey<Level>)worldKey, config, RuntimeWorld.Style.TEMPORARY);
    }

    void enqueueWorldDeletion(ServerLevel world) {
        this.server.m_18707_(() -> this.deletionQueue.add(world));
    }

    private boolean tickDeleteWorld(ServerLevel world) {
        if (this.isWorldUnloaded(world)) {
            this.worldManager.delete(world);
            return true;
        }
        this.kickPlayers(world);
        return false;
    }

    private void kickPlayers(ServerLevel world) {
        if (world.m_6907_().isEmpty()) {
            return;
        }
        ServerLevel overworld = this.server.m_129783_();
        BlockPos spawnPos = overworld.m_220360_();
        float spawnAngle = overworld.m_220361_();
        ArrayList players = new ArrayList(world.m_6907_());
        for (ServerPlayer player : players) {
            player.m_8999_(overworld, (double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, spawnAngle, 0.0f);
        }
    }

    private boolean isWorldUnloaded(ServerLevel world) {
        return world.m_6907_().isEmpty() && world.m_7726_().m_8482_() <= 0;
    }

    public void onServerStopping() {
        List<RuntimeWorld> temporaryWorlds = this.collectTemporaryWorlds();
        for (RuntimeWorld temporary : temporaryWorlds) {
            this.kickPlayers(temporary);
            this.worldManager.delete(temporary);
        }
    }

    private List<RuntimeWorld> collectTemporaryWorlds() {
        ArrayList<RuntimeWorld> temporaryWorlds = new ArrayList<RuntimeWorld>();
        for (ServerLevel world : this.server.m_129785_()) {
            if (!(world instanceof RuntimeWorld)) continue;
            RuntimeWorld runtimeWorld = (RuntimeWorld)world;
            if (runtimeWorld.style != RuntimeWorld.Style.TEMPORARY) continue;
            temporaryWorlds.add(runtimeWorld);
        }
        return temporaryWorlds;
    }

    private static ResourceLocation generateTemporaryWorldKey() {
        String key = RandomStringUtils.random((int)16, (String)"abcdefghijklmnopqrstuvwxyz0123456789");
        return new ResourceLocation(ID, key);
    }
}

