/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.fantasy;

import com.mojang.serialization.Lifecycle;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.apache.commons.io.FileUtils;
import xyz.nucleoid.fantasy.Fantasy;
import xyz.nucleoid.fantasy.FantasyDimensionOptions;
import xyz.nucleoid.fantasy.FantasyInitializer;
import xyz.nucleoid.fantasy.IMC;
import xyz.nucleoid.fantasy.RemoveFromRegistry;
import xyz.nucleoid.fantasy.RuntimeWorld;
import xyz.nucleoid.fantasy.RuntimeWorldConfig;
import xyz.nucleoid.fantasy.mixin.MinecraftServerAccess;

final class RuntimeWorldManager {
    private final MinecraftServer server;
    private final MinecraftServerAccess serverAccess;
    public Map<ResourceKey<Level>, ServerLevel> worldss;

    RuntimeWorldManager(MinecraftServer server) {
        this.server = server;
        this.worldss = new HashMap<ResourceKey<Level>, ServerLevel>();
        this.serverAccess = (MinecraftServerAccess)server;
    }

    RuntimeWorld add(ResourceKey<Level> worldKey, RuntimeWorldConfig config, RuntimeWorld.Style style) {
        LevelStem options = config.createDimensionOptions(this.server);
        if (style == RuntimeWorld.Style.TEMPORARY) {
            ((FantasyDimensionOptions)options).fantasy$setSave(false);
        }
        MappedRegistry<LevelStem> dimensionsRegistry = RuntimeWorldManager.getDimensionsRegistry(this.server);
        boolean isFrozen = ((RemoveFromRegistry)dimensionsRegistry).fantasy$isFrozen();
        ((RemoveFromRegistry)dimensionsRegistry).fantasy$setFrozen(false);
        dimensionsRegistry.m_255290_(ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)worldKey.m_135782_()), (Object)options, Lifecycle.stable());
        ((RemoveFromRegistry)dimensionsRegistry).fantasy$setFrozen(isFrozen);
        RuntimeWorld world = new RuntimeWorld(this.server, worldKey, config, style);
        IMC imc = (IMC)this.server;
        imc.add_world((ResourceKey<Level>)world.m_46472_(), world);
        if (FantasyInitializer.after_tick_start) {
            this.worldss.put((ResourceKey<Level>)world.m_46472_(), world);
        }
        world.m_8793_(() -> true);
        return world;
    }

    void delete(ServerLevel world) {
        ResourceKey dimensionKey = world.m_46472_();
        if (this.serverAccess.getWorlds().remove(dimensionKey, world)) {
            MappedRegistry<LevelStem> dimensionsRegistry = RuntimeWorldManager.getDimensionsRegistry(this.server);
            RemoveFromRegistry.remove(dimensionsRegistry, dimensionKey.m_135782_());
            LevelStorageSource.LevelStorageAccess session = this.serverAccess.getSession();
            File worldDirectory = session.m_197394_(dimensionKey).toFile();
            if (worldDirectory.exists()) {
                try {
                    FileUtils.deleteDirectory((File)worldDirectory);
                }
                catch (IOException e) {
                    Fantasy.LOGGER.warn("Failed to delete world directory", (Throwable)e);
                    try {
                        FileUtils.forceDeleteOnExit((File)worldDirectory);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static MappedRegistry<LevelStem> getDimensionsRegistry(MinecraftServer server) {
        RegistryAccess.Frozen registryManager = server.m_247573_().m_247579_();
        return (MappedRegistry)registryManager.m_175515_(Registries.f_256862_);
    }
}

