/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.fantasy.mixin;

import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.nucleoid.fantasy.FantasyWorldAccess;

@Mixin(value={ServerLevel.class})
public abstract class ServerWorldMixin
implements FantasyWorldAccess {
    private static final int TICK_TIMEOUT = 300;
    @Unique
    private boolean fantasy$tickWhenEmpty = true;
    @Unique
    private int fantasy$tickTimeout;

    @Shadow
    public abstract List<ServerPlayer> m_6907_();

    @Shadow
    public abstract ServerChunkCache m_7726_();

    @Override
    public void fantasy$setTickWhenEmpty(boolean tickWhenEmpty) {
        this.fantasy$tickWhenEmpty = tickWhenEmpty;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void tick(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        boolean shouldTick;
        boolean bl = shouldTick = this.fantasy$tickWhenEmpty || !this.isWorldEmpty();
        if (shouldTick) {
            this.fantasy$tickTimeout = 300;
        } else if (this.fantasy$tickTimeout-- <= 0) {
            ci.cancel();
        }
    }

    @Override
    public boolean fantasy$shouldTick() {
        boolean shouldTick = this.fantasy$tickWhenEmpty || !this.isWorldEmpty();
        return shouldTick || this.fantasy$tickTimeout > 0;
    }

    private boolean isWorldEmpty() {
        return this.m_6907_().isEmpty() && this.m_7726_().m_8482_() <= 0;
    }
}

