/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.bedrockminer.blocks;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.AABB;
import xxrexraptorxx.bedrockminer.registry.ModBlocks;
import xxrexraptorxx.bedrockminer.registry.ModItems;
import xxrexraptorxx.bedrockminer.registry.ModTags;
import xxrexraptorxx.bedrockminer.utils.Config;

public class BlockBedrockBreaker
extends DirectionalBlock {
    public static final EnumProperty<Direction> FACING;
    public static final BooleanProperty POWERED;
    public static final MapCodec<BlockBedrockBreaker> CODEC;

    public BlockBedrockBreaker(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.DOWN)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, POWERED});
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue(FACING, (Comparable)pRot.rotate((Direction)pState.getValue(FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue(FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getNearestLookingVerticalDirection().getOpposite().getOpposite())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && !level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        boolean flag;
        if (!level.isClientSide() && (flag = ((Boolean)state.getValue((Property)POWERED)).booleanValue()) != level.hasNeighborSignal(pos)) {
            if (flag) {
                level.scheduleTick(pos, (Block)this, 4);
                level.playSound((Entity)((Player)null), pos, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.15f + 0.0f);
                level.gameEvent((Holder)GameEvent.BLOCK_DEACTIVATE, pos, GameEvent.Context.of((BlockState)state));
            } else {
                BlockPos harvestBlockPos = ((Direction)state.getValue((Property)DirectionalBlock.FACING)).equals((Object)Direction.DOWN) ? pos.below() : pos.above();
                BlockPos dropPos = ((Direction)state.getValue((Property)DirectionalBlock.FACING)).equals((Object)Direction.DOWN) ? pos.above() : pos.below();
                Block harvestblock = level.getBlockState(harvestBlockPos).getBlock();
                AABB damageArea = new AABB(harvestBlockPos);
                level.playSound((Entity)((Player)null), pos, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.15f + 0.0f);
                level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
                level.gameEvent((Holder)GameEvent.BLOCK_ACTIVATE, pos, GameEvent.Context.of((BlockState)state));
                List entities = level.getEntitiesOfClass(LivingEntity.class, damageArea);
                for (LivingEntity entity : entities) {
                    entity.hurt(level.damageSources().generic(), (float)Config.getMobDamage());
                }
                if (BlockBedrockBreaker.isValidBlock(harvestblock)) {
                    level.playSound(null, pos, SoundEvents.STONE_BREAK, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.15f);
                    if (harvestblock == Blocks.BEDROCK) {
                        ItemEntity item = new ItemEntity(level, (double)dropPos.getX() + 0.5, (double)dropPos.getY(), (double)dropPos.getZ() + 0.5, new ItemStack((ItemLike)harvestblock, 1));
                        level.addFreshEntity((Entity)item);
                    } else {
                        List drops = Block.getDrops((BlockState)harvestblock.defaultBlockState(), (ServerLevel)((ServerLevel)level), (BlockPos)harvestBlockPos, null, null, (ItemStack)new ItemStack((ItemLike)ModItems.BEDROCK_PICKAXE.get()));
                        for (ItemStack drop : drops) {
                            Block.popResource((Level)level, (BlockPos)dropPos, (ItemStack)drop);
                        }
                    }
                    level.destroyBlock(harvestBlockPos, false);
                    level.addDestroyBlockEffect(pos, harvestblock.defaultBlockState());
                } else {
                    level.playSound((Entity)((Player)null), pos, (SoundEvent)SoundEvents.ITEM_BREAK.value(), SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.15f + 0.0f);
                }
            }
        }
    }

    private static boolean isValidBlock(Block block) {
        if (Config.getHarvestOnlyBedrock()) {
            return block == Blocks.BEDROCK || block == ModBlocks.FAKE_BEDROCK.get();
        }
        return !block.defaultBlockState().is(BlockTags.AIR) && !block.defaultBlockState().is(ModTags.BEDROCK_BREAKER_IMMUNE);
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    static {
        CODEC = BlockBedrockBreaker.simpleCodec(BlockBedrockBreaker::new);
        FACING = BlockStateProperties.FACING;
        POWERED = BlockStateProperties.POWERED;
    }
}

