/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.bedrockminer.main;

import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xxrexraptorxx.bedrockminer.registry.CreativeTabs;
import xxrexraptorxx.bedrockminer.registry.ModBlocks;
import xxrexraptorxx.bedrockminer.registry.ModItems;
import xxrexraptorxx.bedrockminer.registry.ModLootModifiers;
import xxrexraptorxx.bedrockminer.utils.Config;
import xxrexraptorxx.magmacore.config.ConfigHelper;
import xxrexraptorxx.magmacore.main.ModRegistry;

@Mod(value="bedrockminer")
public class BedrockMiner {
    public static final Logger LOGGER = LogManager.getLogger();

    public BedrockMiner(IEventBus bus, ModContainer container) {
        ModBlocks.init(bus);
        ModItems.init(bus);
        ModLootModifiers.init(bus);
        CreativeTabs.init(bus);
        bus.addListener(this::addCreative);
        ConfigHelper.registerConfigs((ModContainer)container, (String)"bedrockminer", (boolean)true, (ModConfigSpec)Config.SERVER_CONFIG, null, null, (ModConfigSpec)Config.STARTUP_CONFIG);
        ModRegistry.register((String)"bedrockminer", (String)"Bedrock Miner", (String)"https://www.curseforge.com/minecraft/mc-mods/bedrock-miner");
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        ResourceKey key = event.getTabKey();
        if (key == CreativeModeTabs.INGREDIENTS) {
            event.accept((ItemLike)ModItems.BEDROCK_CHUNK.get());
        } else if (key == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept((ItemLike)ModItems.BEDROCK_SHOVEL.get());
            event.accept((ItemLike)ModItems.BEDROCK_PICKAXE.get());
            event.accept((ItemLike)ModItems.BEDROCK_AXE.get());
            event.accept((ItemLike)ModItems.BEDROCK_HOE.get());
        } else if (key == CreativeModeTabs.COMBAT) {
            event.accept((ItemLike)ModItems.BEDROCK_SWORD.get());
            event.accept((ItemLike)ModItems.BEDROCK_AXE.get());
            event.accept((ItemLike)ModItems.BEDROCK_HELMET.get());
            event.accept((ItemLike)ModItems.BEDROCK_CHESTPLATE.get());
            event.accept((ItemLike)ModItems.BEDROCK_LEGGINGS.get());
            event.accept((ItemLike)ModItems.BEDROCK_BOOTS.get());
        } else if (key == CreativeModeTabs.REDSTONE_BLOCKS) {
            event.accept((ItemLike)ModBlocks.BEDROCK_BREAKER.get());
        } else if (key == CreativeModeTabs.BUILDING_BLOCKS) {
            event.accept((ItemLike)ModBlocks.BEDROCK_BRICKS.get());
            event.accept((ItemLike)ModBlocks.BEDROCK_INFUSED_OBSIDIAN.get());
        }
    }

    @Mod(value="bedrockminer", dist={Dist.CLIENT})
    public static class BedrockMinerClient {
        public BedrockMinerClient(ModContainer container) {
            ConfigHelper.registerIngameConfig((ModContainer)container);
        }
    }
}

