package com.daqem.tinymobfarm;

import com.daqem.tinymobfarm.item.component.LassoData;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_5819;

;

public enum MobFarmType {

    WOOD("wood_farm", class_2246.field_10126, false, new int[]{2, 3, 3}, ConfigTinyMobFarm.woodFarmSpeed.get()),
    STONE("stone_farm", class_2246.field_10340, false, new int[]{1, 2, 3}, ConfigTinyMobFarm.stoneFarmSpeed.get()),
    IRON("iron_farm", class_2246.field_10085, true, new int[]{1, 2}, ConfigTinyMobFarm.ironFarmSpeed.get()),
    GOLD("gold_farm", class_2246.field_10205, true, new int[]{1, 1, 2}, ConfigTinyMobFarm.goldFarmSpeed.get()),
    DIAMOND("diamond_farm", class_2246.field_10201, true, new int[]{1}, ConfigTinyMobFarm.diamondFarmSpeed.get()),
    EMERALD("emerald_farm", class_2246.field_10234, true, new int[]{0, 1, 1}, ConfigTinyMobFarm.emeraldFarmSpeed.get()),
    INFERNAL("inferno_farm", class_2246.field_10540, true, new int[]{0, 0, 1}, ConfigTinyMobFarm.infernoFarmSpeed.get()),
    ULTIMATE("ultimate_farm", class_2246.field_10540, true, new int[]{0}, ConfigTinyMobFarm.ultimateFarmSpeed.get());

    private final String registryName;
    private final class_2248 baseBlock;
    private final boolean canFarmHostile;
    private final int[] damageChance;
    private final double farmSpeed;
    private final Map<Integer, Integer> normalizedChance;

    MobFarmType(String registryName, class_2248 baseBlock, boolean canFarmHostile, int[] damageChance, double farmSpeed) {
        this.registryName = registryName;
        this.baseBlock = baseBlock;
        this.canFarmHostile = canFarmHostile;
        this.damageChance = damageChance;
        this.farmSpeed = farmSpeed;

        this.normalizedChance = new HashMap<>();
        for (int i : this.damageChance) {
            if (!this.normalizedChance.containsKey(i)) this.normalizedChance.put(i, 0);
            this.normalizedChance.put(i, this.normalizedChance.get(i) + 1);
        }
        int denominator = this.damageChance.length;
        this.normalizedChance.replaceAll((i, v) -> (int) (v * 100.0 / denominator));
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public String getUnlocalizedName() {
        return String.format("block.%s.%s", TinyMobFarm.MOD_ID, this.registryName);
    }

    public class_2248 getBaseBlock() {
        return this.baseBlock;
    }

    public boolean isLassoValid(class_1799 lasso) {
        boolean hasData = lasso.method_57826(TinyMobFarm.LASSO_DATA.get());
        if (hasData) {
            LassoData lassoData = lasso.method_58694(TinyMobFarm.LASSO_DATA.get());
            return this.canFarmHostile || !lassoData.mobHostile();
        }
        return false;

    }

    public int getMaxProgress() {
        return (int) (this.farmSpeed * 20);
    }

    public int getRandomDamage(class_5819 rand) {
        return this.damageChance[rand.method_43048(this.damageChance.length)];
    }

    public void addTooltip(Consumer<class_2561> consumer) {
        if (!this.canFarmHostile) {
            consumer.accept(TinyMobFarm.translatable("tooltip.no_hostile", class_124.field_1061));
        }
        consumer.accept(TinyMobFarm.translatable("tooltip.farm_rate", class_124.field_1080, this.farmSpeed));
        consumer.accept(TinyMobFarm.translatable("tooltip.durability_info", class_124.field_1080));
        for (int i : this.normalizedChance.keySet()) {
            if (i == 0) {
                consumer.accept(TinyMobFarm.translatable("tooltip.no_durability", class_124.field_1080, this.normalizedChance.get(i)));
            } else {
                consumer.accept(TinyMobFarm.translatable("tooltip.default_durability", class_124.field_1080, this.normalizedChance.get(i), i));
            }
        }
    }
}
