package com.daqem.tinymobfarm;

import com.daqem.tinymobfarm.block.MobFarmBlock;
import com.daqem.tinymobfarm.blockentity.MobFarmBlockEntity;
import com.daqem.tinymobfarm.client.gui.MobFarmMenu;
import com.daqem.tinymobfarm.event.MobInteractionEvent;
import com.daqem.tinymobfarm.item.LassoItem;
import com.daqem.tinymobfarm.item.MobFarmBlockItem;
import com.daqem.tinymobfarm.item.component.LassoData;
import com.google.common.base.Suppliers;
import com.mojang.logging.LogUtils;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import org.slf4j.Logger;

import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7701;
import net.minecraft.class_7924;
import net.minecraft.class_9331;

public class TinyMobFarm {
    public static final String MOD_ID = "tinymobfarm";
    public static final Logger LOGGER = LogUtils.getLogger();

    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get(MOD_ID));

    public static final Registrar<class_1761> TABS = MANAGER.get().get(class_7924.field_44688);
    public static final RegistrySupplier<class_1761> TINY_MOB_FARM_TAB = TABS.register(getId(MOD_ID + "_tab"), () ->
            CreativeTabRegistry.create(class_2561.method_43471("itemGroup.tiny_mob_farm"),
                    () -> new class_1799(TinyMobFarm.WOODEN_MOB_FARM.get())));

    public static final Registrar<class_3917<?>> MENUS = MANAGER.get().get(class_7924.field_41207);

    public static final RegistrySupplier<class_3917<MobFarmMenu>> MOB_FARM_CONTAINER = MENUS.register(getId("mob_farm_menu"), () -> new class_3917<>(MobFarmMenu::new, class_7701.field_40182));

    public static final Registrar<class_2248> BLOCKS = MANAGER.get().get(class_7924.field_41254);

    public static final RegistrySupplier<MobFarmBlock> WOODEN_MOB_FARM_BLOCK = block(getId("wood_farm"), p -> new MobFarmBlock(MobFarmType.WOOD, p));
    public static final RegistrySupplier<MobFarmBlock> STONE_MOB_FARM_BLOCK = block(getId("stone_farm"), p -> new MobFarmBlock(MobFarmType.STONE, p));
    public static final RegistrySupplier<MobFarmBlock> IRON_MOB_FARM_BLOCK = block(getId("iron_farm"), p -> new MobFarmBlock(MobFarmType.IRON, p));
    public static final RegistrySupplier<MobFarmBlock> GOLD_MOB_FARM_BLOCK = block(getId("gold_farm"), p -> new MobFarmBlock(MobFarmType.GOLD, p));
    public static final RegistrySupplier<MobFarmBlock> DIAMOND_MOB_FARM_BLOCK = block(getId("diamond_farm"), p -> new MobFarmBlock(MobFarmType.DIAMOND, p));
    public static final RegistrySupplier<MobFarmBlock> EMERALD_MOB_FARM_BLOCK = block(getId("emerald_farm"), p -> new MobFarmBlock(MobFarmType.EMERALD, p));
    public static final RegistrySupplier<MobFarmBlock> INFERNAL_MOB_FARM_BLOCK = block(getId("inferno_farm"), p -> new MobFarmBlock(MobFarmType.INFERNAL, p));
    public static final RegistrySupplier<MobFarmBlock> ULTIMATE_MOB_FARM_BLOCK = block(getId("ultimate_farm"), p -> new MobFarmBlock(MobFarmType.ULTIMATE, p));

    public static final Registrar<class_2591<?>> BLOCK_ENTITIES = MANAGER.get().get(class_7924.field_41255);

    public static final RegistrySupplier<class_2591<MobFarmBlockEntity>> MOB_FARM_TILE_ENTITY = BLOCK_ENTITIES.register(getId("mob_farm_block_entity"), () -> new class_2591<>(MobFarmBlockEntity::new, Set.of(TinyMobFarm.WOODEN_MOB_FARM_BLOCK.get(), TinyMobFarm.STONE_MOB_FARM_BLOCK.get(), TinyMobFarm.IRON_MOB_FARM_BLOCK.get(), TinyMobFarm.GOLD_MOB_FARM_BLOCK.get(), TinyMobFarm.DIAMOND_MOB_FARM_BLOCK.get(), TinyMobFarm.EMERALD_MOB_FARM_BLOCK.get(), TinyMobFarm.INFERNAL_MOB_FARM_BLOCK.get(), TinyMobFarm.ULTIMATE_MOB_FARM_BLOCK.get())));

    public static final Registrar<class_9331<?>> COMPONENTS = MANAGER.get().get(class_7924.field_49659);

    public static final RegistrySupplier<class_9331<LassoData>> LASSO_DATA = COMPONENTS.register(getId("lasso_data"), () -> ((class_9331.class_9332) class_9331.method_57873()).method_57881(LassoData.CODEC).method_57882(LassoData.STREAM_CODEC).method_57880());

    public static final Registrar<class_1792> ITEMS = MANAGER.get().get(class_7924.field_41197);

    public static final RegistrySupplier<LassoItem> LASSO = item(getId("lasso"), LassoItem::new);

    public static final RegistrySupplier<MobFarmBlockItem> WOODEN_MOB_FARM = blockItem(getId("wood_farm"), p -> new MobFarmBlockItem(TinyMobFarm.WOODEN_MOB_FARM_BLOCK.get(), p));
    public static final RegistrySupplier<MobFarmBlockItem> STONE_MOB_FARM = blockItem(getId("stone_farm"), p -> new MobFarmBlockItem(TinyMobFarm.STONE_MOB_FARM_BLOCK.get(), p));
    public static final RegistrySupplier<MobFarmBlockItem> IRON_MOB_FARM = blockItem(getId("iron_farm"), p -> new MobFarmBlockItem(TinyMobFarm.IRON_MOB_FARM_BLOCK.get(), p));
    public static final RegistrySupplier<MobFarmBlockItem> GOLD_MOB_FARM = blockItem(getId("gold_farm"), p -> new MobFarmBlockItem(TinyMobFarm.GOLD_MOB_FARM_BLOCK.get(), p));
    public static final RegistrySupplier<MobFarmBlockItem> DIAMOND_MOB_FARM = blockItem(getId("diamond_farm"), p -> new MobFarmBlockItem(TinyMobFarm.DIAMOND_MOB_FARM_BLOCK.get(), p));
    public static final RegistrySupplier<MobFarmBlockItem> EMERALD_MOB_FARM = blockItem(getId("emerald_farm"), p -> new MobFarmBlockItem(TinyMobFarm.EMERALD_MOB_FARM_BLOCK.get(), p));
    public static final RegistrySupplier<MobFarmBlockItem> INFERNAL_MOB_FARM = blockItem(getId("inferno_farm"), p -> new MobFarmBlockItem(TinyMobFarm.INFERNAL_MOB_FARM_BLOCK.get(), p));
    public static final RegistrySupplier<MobFarmBlockItem> ULTIMATE_MOB_FARM = blockItem(getId("ultimate_farm"), p -> new MobFarmBlockItem(TinyMobFarm.ULTIMATE_MOB_FARM_BLOCK.get(), p));

    static <T extends class_2248> RegistrySupplier<T> block(class_2960 id, Function<class_4970.class_2251, T> constructor) {
        return BLOCKS.register(id, () -> constructor.apply(class_4970.class_2251.method_9637().method_63500(class_5321.method_29179(class_7924.field_41254, id))));
    }

    static <T extends class_1792> RegistrySupplier<T> blockItem(class_2960 id, Function<class_1792.class_1793, T> constructor) {
        return ITEMS.register(id, () -> constructor.apply(new class_1792.class_1793().arch$tab(TINY_MOB_FARM_TAB).setId(class_5321.method_29179(class_7924.field_41197, id)).useBlockDescriptionPrefix()));
    }

    static <T extends class_1792> RegistrySupplier<T> item(class_2960 id, Function<class_1792.class_1793, T> constructor) {
        return ITEMS.register(id, () -> constructor.apply(new class_1792.class_1793().arch$tab(TINY_MOB_FARM_TAB).setId(class_5321.method_29179(class_7924.field_41197, id))));
    }

    public static void init() {
        ConfigTinyMobFarm.init();
        MobInteractionEvent.registerEvent();
    }

    public static class_5250 translatable(String s) {
        return translatable(s, new Object[0]);
    }

    public static class_5250 translatable(String s, Object... objects) {
        return class_2561.method_43469(MOD_ID + "." + s, objects);
    }

    public static class_5250 translatable(String s, class_124 color) {
        class_5250 component = translatable(s);
        component.method_27692(color);
        return component;
    }

    public static class_5250 translatable(String s, class_124 color, Object... objects) {
        class_5250 component = translatable(s, objects);
        component.method_27692(color);
        return component;
    }

    public static class_2561 literal(String str) {
        return class_2561.method_43470(str);
    }

    public static class_2960 getId(String str) {
        return class_2960.method_60655(MOD_ID, str);
    }

}
