package com.daqem.tinymobfarm.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

import com.daqem.tinymobfarm.TinyMobFarm;
import com.daqem.tinymobfarm.blockentity.MobFarmBlockEntity;
import com.daqem.tinymobfarm.MobFarmType;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2766;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_9904;
import net.minecraft.world.level.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobFarmBlock extends class_2237 {

	public static final class_2754<class_2350> FACING = class_2383.field_11177;

	private static final class_265 BOUNDING_BOX = class_2248.method_9541(1, 0, 1, 15, 14, 15);

	private final MobFarmType mobFarmType;

	public MobFarmBlock(MobFarmType mobFarmType, class_4970.class_2251 properties) {
		super(properties
				.method_31710(class_3620.field_16023)
				.method_51368(class_2766.field_12653)
				.method_29292()
				.method_9629(1.5f, 6.0f));

		this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043));
		this.mobFarmType = mobFarmType;
	}

	public void getTooltipBuilder(Consumer<class_2561> consumer) {
		this.mobFarmType.addTooltip(consumer);
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(FACING);
	}

	@Nullable
	@Override
	public class_2680 method_9605(class_1750 context) {
		class_2350 facing = context.method_8042().method_10153();
		return this.method_9564().method_11657(FACING, facing);
	}

	@Override
	public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
		super.method_9567(level, pos, state, placer, stack);

		class_2586 tileEntity = level.method_8321(pos);
		if (tileEntity instanceof MobFarmBlockEntity mobFarmBlockEntity) {
			mobFarmBlockEntity.setMobFarmData(mobFarmType);
			mobFarmBlockEntity.updateRedstone();
		}
	}

	@Override
	protected @NotNull class_1269 method_55765(class_1799 itemStack, class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
		if (level.method_8608()) return class_1269.field_5812;

		class_2586 tileEntity = level.method_8321(blockPos);
		if (tileEntity instanceof MobFarmBlockEntity mobFarmBlockEntity) {
			player.method_17355(mobFarmBlockEntity);
		}

		return class_1269.field_5812;
	}

	@Override
	protected @NotNull class_2680 method_9559(class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 blockPos2, class_2680 blockState2, class_5819 randomSource) {
		class_2586 tileEntity = levelReader.method_8321(blockPos);
		if (tileEntity instanceof MobFarmBlockEntity mobFarmBlockEntity) {
			mobFarmBlockEntity.updateRedstone();
			mobFarmBlockEntity.saveAndSync();
		}
		return blockState;
	}

	@Override
	protected void method_9612(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 block, @Nullable class_9904 orientation, boolean bl) {
		class_2586 tileEntity = level.method_8321(blockPos);
		if (tileEntity instanceof MobFarmBlockEntity mobFarmBlockEntity) {
			mobFarmBlockEntity.updateRedstone();
			mobFarmBlockEntity.saveAndSync();
		}
	}

	@Override
	public void method_9556(class_1937 level, class_1657 player, class_2338 blockPos, class_2680 blockState, @Nullable class_2586 blockEntity, class_1799 itemStack) {
		class_2586 tileEntity = level.method_8321(blockPos);
		if (tileEntity instanceof MobFarmBlockEntity mobFarmBlockEntity) {
			class_1799 lasso = mobFarmBlockEntity.getLasso();
			if (!lasso.method_7960()) {
				class_1542 drop = new class_1542(level, blockPos.method_10263() + 0.5, blockPos.method_10264() + 0.3, blockPos.method_10260() + 0.5, lasso);
				level.method_8649(drop);
			}
		}
		super.method_9556(level, player, blockPos, blockState, blockEntity, itemStack);
	}

	@Override
	public @NotNull class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
		return BOUNDING_BOX;
	}

	@Override
	protected boolean method_9579(class_2680 blockState) {
		return true;
	}

	@Override
	protected int method_9505(class_2680 blockState) {
		return 0;
	}

	@Nullable
	@Override
	public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
		return new MobFarmBlockEntity(blockPos, blockState);
	}

	@Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 blockState, class_2591<T> blockEntityType) {
		return MobFarmBlock.method_31618(blockEntityType, TinyMobFarm.MOB_FARM_TILE_ENTITY.get(), MobFarmBlockEntity::tick);
	}

	@Override
	protected @NotNull MapCodec<? extends class_2237> method_53969() {
		return MobFarmBlock.simpleCodecWithMobFarmType(x -> new MobFarmBlock(x, class_4970.class_2251.method_9637()), mobFarmType);
	}

	public static <B extends class_2248> MapCodec<B> simpleCodecWithMobFarmType(Function<MobFarmType, B> function, MobFarmType mobFarmType) {
		return RecordCodecBuilder.mapCodec(instance -> instance.group(class_4970.method_54096()).apply(instance, properties1 -> function.apply(mobFarmType)));
	}

	@Override
	public @NotNull class_2464 method_9604(class_2680 blockState) {
		return class_2464.field_11458;
	}
}
