package com.daqem.tinymobfarm.blockentity;

import com.daqem.tinymobfarm.MobFarmType;
import com.daqem.tinymobfarm.TinyMobFarm;
import com.daqem.tinymobfarm.client.gui.MobFarmMenu;
import com.daqem.tinymobfarm.item.component.LassoData;
import com.daqem.tinymobfarm.util.EntityHelper;
import com.daqem.tinymobfarm.util.FakePlayerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2383;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2614;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_7225;

public class MobFarmBlockEntity extends class_2586 implements class_3908, class_1263 {

    public static final String MOB_FARM_DATA = "mobFarmData";
    public static final String CURR_PROGRESS = "currProgress";

    private MobFarmType mobFarmData;
    private class_1309 livingEntity;
    private class_2350 modelFacing = class_2350.field_11043;
    protected class_2371<class_1799> items = class_2371.method_10213(1, class_1799.field_8037);
    private int progress;
    private boolean powered;
    private boolean shouldUpdate;
    protected final class_3913 dataAccess = new class_3913() {
        @Override
        public int method_17390(int i) {
            return switch (i) {
                case 0 -> MobFarmBlockEntity.this.progress;
                case 1 ->
                        MobFarmBlockEntity.this.mobFarmData == null ? 0 : MobFarmBlockEntity.this.mobFarmData.getMaxProgress();
                case 2 -> MobFarmBlockEntity.this.powered ? 1 : 0;
                case 3 -> MobFarmBlockEntity.this.mobFarmData.ordinal();
                default -> 0;
            };
        }

        @Override
        public void method_17391(int i, int j) {
            switch (i) {
                case 0 -> MobFarmBlockEntity.this.progress = j;
                case 2 -> MobFarmBlockEntity.this.powered = j != 0;
            }
        }

        @Override
        public int method_17389() {
            return 4;
        }
    };

    public MobFarmBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(TinyMobFarm.MOB_FARM_TILE_ENTITY.get(), blockPos, blockState);
    }

    @SuppressWarnings("unused")
    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, MobFarmBlockEntity blockEntity) {
        blockEntity.tick();
    }

    public void tick() {
        if (this.shouldUpdate) {
            this.updateModel();
            this.updateRedstone();
            this.shouldUpdate = false;
        }
        if (this.isWorking()) {
            this.progress++;
            if (this.field_11863 != null) {
                if (!this.field_11863.method_8608() && this.mobFarmData != null) {
                    if (this.progress >= this.mobFarmData.getMaxProgress()) {
                        this.progress = 0;

                        this.generateDrops();

                        if (field_11863 instanceof class_3218 serverLevel) {
                            class_3222 daniel = FakePlayerHelper.getPlayer(serverLevel);
                            this.getLasso().method_7956(this.mobFarmData.getRandomDamage(serverLevel.field_9229), serverLevel, daniel, consumer -> {
                            });
                        }
                        this.saveAndSync();
                    }
                }
            }
        } else {
            this.progress = 0;
        }
    }

    private void generateDrops() {
        class_1799 lasso = this.getLasso();
        if (lasso.method_57826(TinyMobFarm.LASSO_DATA.get())) {
            LassoData stackData = lasso.method_58694(TinyMobFarm.LASSO_DATA.get());
            if (stackData == null) return;

            if (this.field_11863 instanceof class_3218 serverLevel) {
                List<class_1799> drops = EntityHelper.generateLoot(serverLevel, lasso);
                class_1263 container = class_2614.method_11250(serverLevel, method_11016().method_10093(class_2350.field_11033));
                class_2371<class_1799> dummyContainer = class_2371.method_10213(27, class_1799.field_8037);

                // Fill dummyContainer with drops
                for (int i = 0; i < drops.size() && i < dummyContainer.size(); i++) {
                    dummyContainer.set(i, drops.get(i).method_7972()); // Use copy to avoid modifying original drops
                }

                if (container != null && !class_2614.method_11258(container, class_2350.field_11036)) {
                    // Try to insert all items into the container
                    for (class_1799 itemStack : dummyContainer) {
                        if (!itemStack.method_7960()) {
                            // Keep trying to add the item stack until it's either fully inserted or can't fit
                            while (!itemStack.method_7960()) {
                                class_1799 singleItem = itemStack.method_7972();
                                singleItem.method_7939(1);
                                class_1799 remainder = class_2614.method_11260(this, container, singleItem, class_2350.field_11036);
                                if (remainder.method_7960()) {
                                    // Item was successfully added, reduce count
                                    itemStack.method_7934(1);
                                    container.method_5431();
                                } else {
                                    // Item couldn't be added, break to drop it
                                    break;
                                }
                            }
                        }
                    }
                }

                // Drop any remaining items that couldn't fit
                for (class_1799 stack : dummyContainer) {
                    if (!stack.method_7960()) {
                        class_1542 entityItem = new class_1542(
                                this.field_11863,
                                this.field_11867.method_10263() + 0.5,
                                this.field_11867.method_10264() + 1,
                                this.field_11867.method_10260() + 0.5,
                                stack.method_7972()
                        );
                        this.field_11863.method_8649(entityItem);
                    }
                }
            }
        }
    }

    private void updateModel() {
        if (this.field_11863 == null) return;
        if (this.field_11863.method_8608()) {
            if (this.getLasso().method_7960()) {
                this.livingEntity = null;
            } else {
                LassoData data = this.getLasso().method_58694(TinyMobFarm.LASSO_DATA.get());
                if (data != null) {
                    String mobName = data.mobName();
                    String mobId = data.mobId().toString();
                    //noinspection EqualsBetweenInconvertibleTypes
                    if (this.livingEntity == null || !this.livingEntity.method_5477().method_10851().equals(mobName)) {
                        class_2487 entityData = data.mobData();
                        entityData.method_10582("id", mobId);
                        class_1297 newModel = class_1299.method_71371(entityData, this.field_11863, class_3730.field_16462, entity -> entity);

                        if (newModel instanceof class_1309) {
                            this.livingEntity = (class_1309) newModel;
                            this.modelFacing = this.field_11863.method_8320(this.field_11867).method_11654(class_2383.field_11177);
                        }
                    }
                }
            }
        }
    }

    public boolean isWorking() {
        if (this.mobFarmData == null || this.getLasso().method_7960() || this.isPowered()) return false;
        return this.mobFarmData.isLassoValid(this.getLasso());
    }

    public void updateRedstone() {
        if (this.field_11863 == null) return;
        this.powered = this.field_11863.method_49804(field_11867) != 0;
    }

    public class_1799 getLasso() {
        return this.items.getFirst();
    }

    public void setMobFarmData(MobFarmType mobFarmData) {
        this.mobFarmData = mobFarmData;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public class_1309 getLivingEntity() {
        return this.livingEntity;
    }

    public class_2350 getModelFacing() {
        return this.modelFacing;
    }

    public void saveAndSync() {
        if (this.field_11863 == null) return;
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        this.field_11863.method_8413(field_11867, state, state, 3);
        this.method_5431();
    }

    @Override
    protected void method_11014(class_11368 input) {
        super.method_11014(input);
        input.method_71439(MOB_FARM_DATA).ifPresent(value -> this.mobFarmData = MobFarmType.values()[value]);
        input.method_71439(CURR_PROGRESS).ifPresent(value -> this.progress = value);
        this.items = class_2371.method_10213(this.method_5439(), class_1799.field_8037);
        class_1262.method_5429(input, this.items);
        this.shouldUpdate = true;
    }

    @Override
    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        if (this.mobFarmData != null) {
            output.method_71465(MOB_FARM_DATA, this.mobFarmData.ordinal());
            output.method_71465(CURR_PROGRESS, this.progress);
            class_1262.method_5426(output, this.items);
        }
    }

    @Nullable
    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public @NotNull class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }

    @Override
    public class_1703 createMenu(int windowId, class_1661 inv, class_1657 player) {
        return new MobFarmMenu(windowId, inv, this, this.dataAccess);
    }

    @Override
    public @NotNull class_2561 method_5476() {
        return class_2561.method_43471(mobFarmData.getUnlocalizedName());
    }

    @Override
    public int method_5439() {
        return this.items.size();
    }

    @Override
    public boolean method_5442() {
        for (class_1799 itemStack : this.items) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    @Override
    public @NotNull class_1799 method_5438(int i) {
        return this.items.get(i);
    }

    @Override
    public @NotNull class_1799 method_5434(int i, int j) {
        return class_1262.method_5430(this.items, i, j);
    }

    @Override
    public @NotNull class_1799 method_5441(int i) {
        return class_1262.method_5428(this.items, i);
    }

    @Override
    public void method_5447(int i, class_1799 itemStack) {
        class_1799 itemStack2 = this.items.get(i);
        boolean bl = !itemStack.method_7960() && class_1799.method_31577(itemStack2, itemStack);
        this.items.set(i, itemStack);
        if (itemStack.method_7947() > this.method_5444()) {
            itemStack.method_7939(this.method_5444());
        }
        if (i == 0 && !bl) {
            this.progress = 0;
            this.method_5431();
        }
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105(this, player);
    }

    @Override
    public void method_5448() {
        this.items.clear();
    }

    @Override
    public void method_5431() {
        super.method_5431();
        this.shouldUpdate = true;
    }
}
