package com.daqem.tinymobfarm.client.gui;

import com.daqem.tinymobfarm.MobFarmType;
import com.daqem.tinymobfarm.TinyMobFarm;
import com.daqem.tinymobfarm.blockentity.MobFarmBlockEntity;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3913;
import net.minecraft.class_3919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobFarmMenu extends class_1703 {

	public static final int LASSO_SLOT = 0;
	public static final int LASSO_SLOT_X = 71;
	public static final int LASSO_SLOT_Y = 33;

	private final class_3913 containerData;

	public MobFarmMenu(int windowId, class_1661 inv, class_1263 container, class_3913 containerData) {
		super(TinyMobFarm.MOB_FARM_CONTAINER.get(), windowId);

		this.containerData = containerData;

		this.method_7621(new LassoSlot(container, LASSO_SLOT, LASSO_SLOT_X, LASSO_SLOT_Y) {
			@Override
			public void method_7668() {
				super.method_7668();
				if (this.field_7871 instanceof MobFarmBlockEntity mobFarmBlockEntity) {
					mobFarmBlockEntity.saveAndSync();
				}
			}
		});
		
		for (int i = 0; i < 9; i++) {
			this.method_7621(new class_1735(inv, i, i * 18 + 8, 142));
		}
		
		for (int i = 0; i < 9; i++) {
			for (int j = 0; j < 3; j++) {
				this.method_7621(new class_1735(inv, i + j * 9 + 9, i * 18 + 8, j * 18 + 84));
			}
		}

		this.method_17360(containerData);
	}

	public MobFarmMenu(int i, class_1661 inventory) {
		this(i, inventory, new class_1277(1), new class_3919(4));
	}

	@Override
	public boolean method_7597(class_1657 player) {
		return true;
	}
	
	@Override
	public @NotNull class_1799 method_7601(class_1657 player, int index) {
		class_1735 slot = field_7761.get(index);
		if (!slot.method_7681()) {
			return class_1799.field_8037;
		}

		class_1799 originalItemStack = slot.method_7677();
		class_1799 copiedItemStack = originalItemStack.method_7972();

		int containerSlots = field_7761.size() - player.method_31548().method_67533().size();
		boolean moved = index < containerSlots
				? this.method_7616(originalItemStack, containerSlots, field_7761.size(), true)
				: this.method_7616(originalItemStack, 0, containerSlots, false);

		if (!moved) {
			return class_1799.field_8037;
		}

		if (originalItemStack.method_7947() == 0) {
			slot.method_7673(class_1799.field_8037);
		} else {
			slot.method_7668();
		}

		if (originalItemStack.method_7947() == copiedItemStack.method_7947()) {
			return class_1799.field_8037;
		}

		slot.method_7667(player, originalItemStack);
		return copiedItemStack;
	}

	public int getProgress() {
		return this.containerData.method_17390(0);
	}

	public int getMaxProgress() {
		return this.containerData.method_17390(1);
	}

	public boolean isPowered() {
		return this.containerData.method_17390(2) > 0;
	}

	public @Nullable MobFarmType getMobFarmType() {
		int ordinal = this.containerData.method_17390(3);
		return ordinal >= 0 && ordinal < MobFarmType.values().length ? MobFarmType.values()[ordinal] : null;
	}
}
