package com.daqem.tinymobfarm.client.gui.components;

import com.daqem.tinymobfarm.util.EntityHelper;
import com.daqem.uilib.gui.component.AbstractComponent;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_332;

import static net.minecraft.class_490.method_2486;

public class EntityComponent extends AbstractComponent {

    private final Supplier<class_1799> itemStackSupplier;

    public EntityComponent(int x, int y, int width, int height, Supplier<class_1799> itemStackSupplier) {
        super(x, y, width, height);
        this.itemStackSupplier = itemStackSupplier;
    }

    public void renderEntity(class_332 guiGraphics, int mouseX, int mouseY) {
        class_1799 lasso = itemStackSupplier.get();
        if (lasso.method_7960()) return;
        class_1309 livingEntity = (class_1309) EntityHelper.getEntityFromLasso(lasso, class_2338.field_10980, class_310.method_1551().field_1687);
        if (livingEntity == null) return;
        method_2486(
                guiGraphics,
                getTotalX(),
                getTotalY(),
                getTotalX() + method_25368(),
                getTotalY() + method_25364(),
                30,
                0.0625F,
                mouseX,
                mouseY,
                livingEntity
        );
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        renderEntity(guiGraphics, mouseX, mouseY);
    }
}
