package com.daqem.tinymobfarm.client.gui.components;

import com.daqem.tinymobfarm.MobFarmType;
import com.daqem.tinymobfarm.TinyMobFarm;
import com.daqem.tinymobfarm.client.gui.MobFarmScreen;
import com.daqem.tinymobfarm.item.LassoItem;
import com.daqem.uilib.gui.component.sprite.SpriteComponent;
import com.daqem.uilib.gui.component.text.TextAlign;
import com.daqem.uilib.gui.component.text.TextComponent;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class MobFarmComponent extends SpriteComponent {

    private static final int WIDTH = 176;
    private static final int HEIGHT = 166;
    private static final class_2561 REDSTONE_DISABLE = TinyMobFarm.translatable("gui.redstone_disable");
    private static final class_2561 HIGHER_TIER = TinyMobFarm.translatable("gui.higher_tier");

    private final MobFarmScreen parent;

    private final TextComponent errorText;
    private final TextComponent entityNameComponent;
    private final ProgressBarComponent progressBarComponent;

    public MobFarmComponent(MobFarmScreen parent) {
        super(0, 0, WIDTH, HEIGHT, TinyMobFarm.getId("mob_farm_background"));
        this.parent = parent;

        this.errorText = new TextComponent(0, -10, class_2561.method_43473());
        this.errorText.centerHorizontally();
        this.errorText.setTextAlign(TextAlign.CENTER);
        TextComponent titleComponent = new TextComponent(8, 5, parent.method_25440(), 0xFF404040);
        EntityComponent entityComponent = new EntityComponent(8, 15, 52, 63, parent::getLasso);
        this.entityNameComponent = new TextComponent(90, 37, class_2561.method_43473(), 0xFF555555);
        this.progressBarComponent = new ProgressBarComponent(71, 55, 97, 5, 0xFF3de031, parent.method_17577().getProgress(), parent.method_17577().getMaxProgress());

        this.addComponent(this.errorText);
        this.addComponent(titleComponent);
        this.addComponent(entityComponent);
        this.addComponent(this.entityNameComponent);
        this.addComponent(this.progressBarComponent);
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        super.render(guiGraphics, mouseX, mouseY, partialTick, parentWidth, parentHeight);
        errorText.setText(getLassoError());

        this.entityNameComponent.setText(
                parent.getLasso().method_7909() instanceof LassoItem lassoItem ?
                        lassoItem.getMobName(parent.getLasso()) :
                        class_2561.method_43473()
        );

        this.progressBarComponent.setProgress(parent.method_17577().getProgress());
        this.progressBarComponent.setMaxProgress(parent.method_17577().getMaxProgress());
    }

    private class_2561 getLassoError() {
        class_1799 lasso = parent.getLasso();

        class_2561 component;
        if (parent.method_17577().isPowered()) {
            component = REDSTONE_DISABLE;
        } else {
            MobFarmType type = parent.method_17577().getMobFarmType();
            if (type != null && lasso != null && !lasso.method_31574(class_1802.field_8162) && !type.isLassoValid(lasso)) {
                component = HIGHER_TIER;
            } else {
                return class_2561.method_43473();
            }
        }

        return component.method_27661().method_54663(0xFFFF5555);
    }
}
