package com.daqem.tinymobfarm.client.render;

import com.daqem.tinymobfarm.blockentity.MobFarmBlockEntity;
import net.minecraft.class_10017;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_2281;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.minecraft.class_898;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobFarmRenderer implements class_827<MobFarmBlockEntity, MobFarmRenderState> {
    private final class_898 entityRenderer;

    public MobFarmRenderer(class_5614.class_5615 context) {
        this.entityRenderer = context.comp_4538();
    }

    @Override
    public @NotNull MobFarmRenderState method_74335() {
        return new MobFarmRenderState();
    }

    public void extractRenderState(
            MobFarmBlockEntity mobFarmBlockEntity,
            MobFarmRenderState MobFarmRenderState,
            float f,
            class_243 vec3,
            @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_827.super.method_74331(mobFarmBlockEntity, MobFarmRenderState, f, vec3, crumblingOverlay);
        if (mobFarmBlockEntity.method_10997() != null) {
            class_1297 entity = mobFarmBlockEntity.getLivingEntity();
            extractMobFarmData(MobFarmRenderState, f, entity, this.entityRenderer);
        }
        MobFarmRenderState.angle = mobFarmBlockEntity.method_11010().method_11654(class_2281.field_10768).method_10144();
    }

    static void extractMobFarmData(
            MobFarmRenderState renderState, float f, @Nullable class_1297 entity, class_898 entityRenderDispatcher
    ) {
        if (entity != null) {
            renderState.displayEntity = entityRenderDispatcher.method_72977(entity, f);
            renderState.displayEntity.field_61820 = renderState.field_62676;
            renderState.scale = 0.53125F;
            float g = Math.max(entity.method_17681(), entity.method_17682());
            if (g > 1.0) {
                renderState.scale /= g;
            }
        }
    }

    public void submit(MobFarmRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        if (renderState.displayEntity != null) {
            submitEntityInMobFarm(
                    poseStack, submitNodeCollector, renderState.displayEntity, this.entityRenderer, renderState.scale, renderState.angle, cameraRenderState
            );
        }
    }

    public static void submitEntityInMobFarm(
            class_4587 poseStack,
            class_11659 submitNodeCollector,
            class_10017 entityRenderState,
            class_898 entityRenderDispatcher,
            float scale,
            float angle,
            class_12075 cameraRenderState
    ) {
        poseStack.method_22903();
        poseStack.method_46416(0.5F, 0.125F, 0.5F);
        poseStack.method_22905(scale, scale, scale);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(-angle));
        entityRenderDispatcher.method_72976(entityRenderState, cameraRenderState, 0.0, 0.0, 0.0, poseStack, submitNodeCollector);
        poseStack.method_22909();
    }
}
