package com.daqem.tinymobfarm.util;

import com.daqem.tinymobfarm.ConfigTinyMobFarm;
import com.daqem.tinymobfarm.TinyMobFarm;
import com.daqem.tinymobfarm.item.component.LassoData;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8111;
import net.minecraft.class_8567;

public class EntityHelper {

    public static List<class_1799> generateLoot(class_3218 level, class_1799 stack) {
        class_1297 entity = getEntityFromLasso(stack, class_2338.field_10980, level);
        if (entity == null) return new ArrayList<>();

        class_5321<class_52> lootTableKey = entity.method_5864().method_16351().get();
        class_52 lootTable = level.method_8503().method_58576().method_58295(lootTableKey);

        class_3222 daniel = FakePlayerHelper.getPlayer(level);
        if (daniel == null) {
            throw new IllegalStateException("Failed to retrieve fake player");
        }

        class_6880<class_1887> registryReference = level.method_30349()
                .method_46759(class_1893.field_9110.method_58273())
                .flatMap(lookup -> lookup.method_46746(class_1893.field_9110))
                .orElseThrow(() -> new IllegalStateException("Looting enchantment not found"));

        int lootingLevel = class_1890.method_8225(registryReference, stack);
        class_1799 sword = new class_1799(class_1802.field_8802);

        if (ConfigTinyMobFarm.allowLassoLooting.get() && lootingLevel > 0) {
            sword.method_7978(registryReference, lootingLevel);
        }
        daniel.method_7270(sword);

        class_6880<class_8110> damageTypeHolder = level.method_30349().method_46759(class_7924.field_42534)
                .flatMap(lookup -> lookup.method_46746(class_8111.field_42320))
                .orElseThrow(() -> new IllegalStateException("Damage type not found"));
        class_1282 damageSource = new class_1282(damageTypeHolder, daniel);

        class_8567 lootParams = new class_8567.class_8568(level)
                .method_51874(class_181.field_1230, daniel)
                .method_51874(class_181.field_1227, daniel)
                .method_51874(class_181.field_1233, daniel)
                .method_51874(class_181.field_1226, entity)
                .method_51874(class_181.field_24424, entity.method_73189())
                .method_51874(class_181.field_1231, damageSource)
                .method_51875(class_173.field_1173);

        return lootTable.method_51878(lootParams);
    }


    public static class_1297 getEntityFromLasso(class_1799 lasso, class_2338 pos, class_1937 level) {
        if (!lasso.method_57826(TinyMobFarm.LASSO_DATA.get())) return null;
        LassoData data = lasso.method_58694(TinyMobFarm.LASSO_DATA.get());
        if (data == null) return null;
        class_2487 mobData = data.mobData();
        class_2960 id = data.mobId();

        class_2489 x = class_2489.method_23241(pos.method_10263() + 0.5);
        class_2489 y = class_2489.method_23241(pos.method_10264());
        class_2489 z = class_2489.method_23241(pos.method_10260() + 0.5);
        class_2499 mobPos = new class_2499();
        mobPos.add(x);
        mobPos.add(y);
        mobPos.add(z);
        mobData.method_10566("Pos", mobPos);
        mobData.method_10582("id", id.toString());

        return class_1299.method_71371(mobData, level, class_3730.field_16471, entity -> entity);
    }
}
