/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.tinymobfarm;

import com.daqem.tinymobfarm.ConfigTinyMobFarm;
import com.daqem.tinymobfarm.TinyMobFarm;
import com.daqem.tinymobfarm.item.component.LassoData;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_5819;
import net.minecraft.class_9331;

public enum MobFarmType {
    WOOD("wood_farm", class_2246.field_10126, false, new int[]{2, 3, 3}, (Double)ConfigTinyMobFarm.woodFarmSpeed.get()),
    STONE("stone_farm", class_2246.field_10340, false, new int[]{1, 2, 3}, (Double)ConfigTinyMobFarm.stoneFarmSpeed.get()),
    IRON("iron_farm", class_2246.field_10085, true, new int[]{1, 2}, (Double)ConfigTinyMobFarm.ironFarmSpeed.get()),
    GOLD("gold_farm", class_2246.field_10205, true, new int[]{1, 1, 2}, (Double)ConfigTinyMobFarm.goldFarmSpeed.get()),
    DIAMOND("diamond_farm", class_2246.field_10201, true, new int[]{1}, (Double)ConfigTinyMobFarm.diamondFarmSpeed.get()),
    EMERALD("emerald_farm", class_2246.field_10234, true, new int[]{0, 1, 1}, (Double)ConfigTinyMobFarm.emeraldFarmSpeed.get()),
    INFERNAL("inferno_farm", class_2246.field_10540, true, new int[]{0, 0, 1}, (Double)ConfigTinyMobFarm.infernoFarmSpeed.get()),
    ULTIMATE("ultimate_farm", class_2246.field_10540, true, new int[]{0}, (Double)ConfigTinyMobFarm.ultimateFarmSpeed.get());

    private final String registryName;
    private final class_2248 baseBlock;
    private final boolean canFarmHostile;
    private final int[] damageChance;
    private final double farmSpeed;
    private final Map<Integer, Integer> normalizedChance;

    private MobFarmType(String registryName, class_2248 baseBlock, boolean canFarmHostile, int[] damageChance, double farmSpeed) {
        this.registryName = registryName;
        this.baseBlock = baseBlock;
        this.canFarmHostile = canFarmHostile;
        this.damageChance = damageChance;
        this.farmSpeed = farmSpeed;
        this.normalizedChance = new HashMap<Integer, Integer>();
        for (int i2 : this.damageChance) {
            if (!this.normalizedChance.containsKey(i2)) {
                this.normalizedChance.put(i2, 0);
            }
            this.normalizedChance.put(i2, this.normalizedChance.get(i2) + 1);
        }
        int denominator = this.damageChance.length;
        this.normalizedChance.replaceAll((i, v) -> (int)((double)v.intValue() * 100.0 / (double)denominator));
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public String getUnlocalizedName() {
        return String.format("block.%s.%s", "tinymobfarm", this.registryName);
    }

    public class_2248 getBaseBlock() {
        return this.baseBlock;
    }

    public boolean isLassoValid(class_1799 lasso) {
        boolean hasData = lasso.method_57826((class_9331)TinyMobFarm.LASSO_DATA.get());
        if (hasData) {
            LassoData lassoData = (LassoData)lasso.method_58694((class_9331)TinyMobFarm.LASSO_DATA.get());
            return this.canFarmHostile || !lassoData.mobHostile();
        }
        return false;
    }

    public int getMaxProgress() {
        return (int)(this.farmSpeed * 20.0);
    }

    public int getRandomDamage(class_5819 rand) {
        return this.damageChance[rand.method_43048(this.damageChance.length)];
    }

    public void addTooltip(Consumer<class_2561> consumer) {
        if (!this.canFarmHostile) {
            consumer.accept((class_2561)TinyMobFarm.translatable("tooltip.no_hostile", class_124.field_1061));
        }
        consumer.accept((class_2561)TinyMobFarm.translatable("tooltip.farm_rate", class_124.field_1080, new Object[]{this.farmSpeed}));
        consumer.accept((class_2561)TinyMobFarm.translatable("tooltip.durability_info", class_124.field_1080));
        for (int i : this.normalizedChance.keySet()) {
            if (i == 0) {
                consumer.accept((class_2561)TinyMobFarm.translatable("tooltip.no_durability", class_124.field_1080, new Object[]{this.normalizedChance.get(i)}));
                continue;
            }
            consumer.accept((class_2561)TinyMobFarm.translatable("tooltip.default_durability", class_124.field_1080, new Object[]{this.normalizedChance.get(i), i}));
        }
    }
}

