/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.tinymobfarm.blockentity;

import com.daqem.tinymobfarm.MobFarmType;
import com.daqem.tinymobfarm.TinyMobFarm;
import com.daqem.tinymobfarm.client.gui.MobFarmMenu;
import com.daqem.tinymobfarm.item.component.LassoData;
import com.daqem.tinymobfarm.util.EntityHelper;
import com.daqem.tinymobfarm.util.FakePlayerHelper;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2383;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2614;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobFarmBlockEntity
extends class_2586
implements class_3908,
class_1263 {
    public static final String MOB_FARM_DATA = "mobFarmData";
    public static final String CURR_PROGRESS = "currProgress";
    private MobFarmType mobFarmData;
    private class_1309 livingEntity;
    private class_2350 modelFacing = class_2350.field_11043;
    protected class_2371<class_1799> items = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private int progress;
    private boolean powered;
    private boolean shouldUpdate;
    protected final class_3913 dataAccess = new class_3913(){

        public int method_17390(int i) {
            return switch (i) {
                case 0 -> MobFarmBlockEntity.this.progress;
                case 1 -> {
                    if (MobFarmBlockEntity.this.mobFarmData == null) {
                        yield 0;
                    }
                    yield MobFarmBlockEntity.this.mobFarmData.getMaxProgress();
                }
                case 2 -> {
                    if (MobFarmBlockEntity.this.powered) {
                        yield 1;
                    }
                    yield 0;
                }
                case 3 -> MobFarmBlockEntity.this.mobFarmData.ordinal();
                default -> 0;
            };
        }

        public void method_17391(int i, int j) {
            switch (i) {
                case 0: {
                    MobFarmBlockEntity.this.progress = j;
                    break;
                }
                case 2: {
                    MobFarmBlockEntity.this.powered = j != 0;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };

    public MobFarmBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)TinyMobFarm.MOB_FARM_TILE_ENTITY.get(), blockPos, blockState);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, MobFarmBlockEntity blockEntity) {
        blockEntity.tick();
    }

    public void tick() {
        if (this.shouldUpdate) {
            this.updateModel();
            this.updateRedstone();
            this.shouldUpdate = false;
        }
        if (this.isWorking()) {
            ++this.progress;
            if (this.field_11863 != null && !this.field_11863.method_8608() && this.mobFarmData != null && this.progress >= this.mobFarmData.getMaxProgress()) {
                this.progress = 0;
                this.generateDrops();
                class_1937 class_19372 = this.field_11863;
                if (class_19372 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    class_3222 daniel = FakePlayerHelper.getPlayer(serverLevel);
                    this.getLasso().method_7956(this.mobFarmData.getRandomDamage(serverLevel.field_9229), serverLevel, daniel, consumer -> {});
                }
                this.saveAndSync();
            }
        } else {
            this.progress = 0;
        }
    }

    private void generateDrops() {
        class_1799 lasso = this.getLasso();
        if (lasso.method_57826((class_9331)TinyMobFarm.LASSO_DATA.get())) {
            LassoData stackData = (LassoData)lasso.method_58694((class_9331)TinyMobFarm.LASSO_DATA.get());
            if (stackData == null) {
                return;
            }
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                List<class_1799> drops = EntityHelper.generateLoot(serverLevel, lasso);
                class_1263 container = class_2614.method_11250((class_1937)serverLevel, (class_2338)this.method_11016().method_10093(class_2350.field_11033));
                class_2371 dummyContainer = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
                for (int i = 0; i < drops.size() && i < dummyContainer.size(); ++i) {
                    dummyContainer.set(i, (Object)drops.get(i).method_7972());
                }
                if (container != null && !class_2614.method_11258((class_1263)container, (class_2350)class_2350.field_11036)) {
                    block1: for (class_1799 itemStack : dummyContainer) {
                        if (itemStack.method_7960()) continue;
                        while (!itemStack.method_7960()) {
                            class_1799 singleItem = itemStack.method_7972();
                            singleItem.method_7939(1);
                            class_1799 remainder = class_2614.method_11260((class_1263)this, (class_1263)container, (class_1799)singleItem, (class_2350)class_2350.field_11036);
                            if (!remainder.method_7960()) continue block1;
                            itemStack.method_7934(1);
                            container.method_5431();
                        }
                    }
                }
                for (class_1799 stack : dummyContainer) {
                    if (stack.method_7960()) continue;
                    class_1542 entityItem = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260() + 0.5, stack.method_7972());
                    this.field_11863.method_8649((class_1297)entityItem);
                }
            }
        }
    }

    private void updateModel() {
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.method_8608()) {
            if (this.getLasso().method_7960()) {
                this.livingEntity = null;
            } else {
                LassoData data = (LassoData)this.getLasso().method_58694((class_9331)TinyMobFarm.LASSO_DATA.get());
                if (data != null) {
                    String mobName = data.mobName();
                    String mobId = data.mobId().toString();
                    if (this.livingEntity == null || !this.livingEntity.method_5477().method_10851().equals((Object)mobName)) {
                        class_2487 entityData = data.mobData();
                        entityData.method_10582("id", mobId);
                        class_1297 newModel = class_1299.method_71371((class_2487)entityData, (class_1937)this.field_11863, (class_3730)class_3730.field_16462, entity -> entity);
                        if (newModel instanceof class_1309) {
                            this.livingEntity = (class_1309)newModel;
                            this.modelFacing = (class_2350)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)class_2383.field_11177);
                        }
                    }
                }
            }
        }
    }

    public boolean isWorking() {
        if (this.mobFarmData == null || this.getLasso().method_7960() || this.isPowered()) {
            return false;
        }
        return this.mobFarmData.isLassoValid(this.getLasso());
    }

    public void updateRedstone() {
        if (this.field_11863 == null) {
            return;
        }
        this.powered = this.field_11863.method_49804(this.field_11867) != 0;
    }

    public class_1799 getLasso() {
        return (class_1799)this.items.getFirst();
    }

    public void setMobFarmData(MobFarmType mobFarmData) {
        this.mobFarmData = mobFarmData;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public class_1309 getLivingEntity() {
        return this.livingEntity;
    }

    public class_2350 getModelFacing() {
        return this.modelFacing;
    }

    public void saveAndSync() {
        if (this.field_11863 == null) {
            return;
        }
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        this.field_11863.method_8413(this.field_11867, state, state, 3);
        this.method_5431();
    }

    protected void method_11014(class_11368 input) {
        super.method_11014(input);
        input.method_71439(MOB_FARM_DATA).ifPresent(value -> {
            this.mobFarmData = MobFarmType.values()[value];
        });
        input.method_71439(CURR_PROGRESS).ifPresent(value -> {
            this.progress = value;
        });
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_11368)input, this.items);
        this.shouldUpdate = true;
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        if (this.mobFarmData != null) {
            output.method_71465(MOB_FARM_DATA, this.mobFarmData.ordinal());
            output.method_71465(CURR_PROGRESS, this.progress);
            class_1262.method_5426((class_11372)output, this.items);
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }

    public class_1703 createMenu(int windowId, class_1661 inv, class_1657 player) {
        return new MobFarmMenu(windowId, inv, this, this.dataAccess);
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.mobFarmData.getUnlocalizedName());
    }

    public int method_5439() {
        return this.items.size();
    }

    public boolean method_5442() {
        for (class_1799 itemStack : this.items) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public class_1799 method_5438(int i) {
        return (class_1799)this.items.get(i);
    }

    @NotNull
    public class_1799 method_5434(int i, int j) {
        return class_1262.method_5430(this.items, (int)i, (int)j);
    }

    @NotNull
    public class_1799 method_5441(int i) {
        return class_1262.method_5428(this.items, (int)i);
    }

    public void method_5447(int i, class_1799 itemStack) {
        class_1799 itemStack2 = (class_1799)this.items.get(i);
        boolean bl = !itemStack.method_7960() && class_1799.method_31577((class_1799)itemStack2, (class_1799)itemStack);
        this.items.set(i, (Object)itemStack);
        if (itemStack.method_7947() > this.method_5444()) {
            itemStack.method_7939(this.method_5444());
        }
        if (i == 0 && !bl) {
            this.progress = 0;
            this.method_5431();
        }
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public void method_5448() {
        this.items.clear();
    }

    public void method_5431() {
        super.method_5431();
        this.shouldUpdate = true;
    }
}

