/*
 * Decompiled with CFR 0.152.
 */
package io.github.glyphmods.wailt;

import io.github.glyphmods.wailt.Config;
import io.github.glyphmods.wailt.InfoToast;
import io.github.glyphmods.wailt.SongToast;
import io.github.glyphmods.wailt.Tracks;
import io.github.glyphmods.wailt.WAILT;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.sound.PlayStreamingSourceEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/github/glyphmods/wailt/ToastDispatcher;", "", "toastComponent", "Lnet/minecraft/client/gui/components/toasts/ToastComponent;", "<init>", "(Lnet/minecraft/client/gui/components/toasts/ToastComponent;)V", "missingSongs", "", "Lnet/minecraft/resources/ResourceLocation;", "dispatchToast", "", "location", "wailt"})
@SourceDebugExtension(value={"SMAP\nToastDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToastDispatcher.kt\nio/github/glyphmods/wailt/ToastDispatcher\n+ 2 Forge.kt\nthedarkcolour/kotlinforforge/neoforge/forge/ForgeKt\n*L\n1#1,50:1\n17#2:51\n17#2:52\n*S KotlinDebug\n*F\n+ 1 ToastDispatcher.kt\nio/github/glyphmods/wailt/ToastDispatcher\n*L\n15#1:51\n22#1:52\n*E\n"})
public final class ToastDispatcher {
    @NotNull
    private final ToastComponent toastComponent;
    @NotNull
    private final Set<ResourceLocation> missingSongs;

    public ToastDispatcher(@NotNull ToastComponent toastComponent) {
        Intrinsics.checkNotNullParameter((Object)toastComponent, (String)"toastComponent");
        this.toastComponent = toastComponent;
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(arg_0 -> ToastDispatcher._init_$lambda$0(this, arg_0));
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus2 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus2, (String)"EVENT_BUS");
        iEventBus2.addListener(arg_0 -> ToastDispatcher._init_$lambda$2(this, arg_0));
        this.missingSongs = new LinkedHashSet();
    }

    private final void dispatchToast(ResourceLocation location) {
        Tracks.Track track = Tracks.INSTANCE.get(location);
        boolean fancy = Config.INSTANCE.getDisableToastColors().isFalse();
        if (track != null) {
            this.toastComponent.addToast((Toast)new SongToast(track.getArtist().nameComponent(fancy), track.getName()));
        } else {
            MutableComponent mutableComponent = Component.translatable((String)"gui.wailt.toast.unknown");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            Component component = (Component)mutableComponent;
            MutableComponent mutableComponent2 = Component.literal((String)location.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"literal(...)");
            this.toastComponent.addToast((Toast)new SongToast(component, (Component)mutableComponent2));
            if (this.missingSongs.add(location)) {
                WAILT.INSTANCE.getLOGGER().warn("No metadata is defined for music track " + location);
            }
        }
    }

    private static final void _init_$lambda$0(ToastDispatcher this$0, PlayStreamingSourceEvent event) {
        SoundInstance sound = event.getSound();
        if (sound.getSource() == SoundSource.MUSIC && ((Boolean)Config.INSTANCE.getAutomaticallyShowToast().get()).booleanValue()) {
            ResourceLocation resourceLocation = sound.getSound().getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getLocation(...)");
            this$0.dispatchToast(resourceLocation);
        }
    }

    private static final void _init_$lambda$2(ToastDispatcher this$0, ClientTickEvent.Pre it) {
        Minecraft minecraft = Minecraft.getInstance();
        while (WAILT.INSTANCE.getSHOW_TOAST_KEYBIND().consumeClick()) {
            if (minecraft.getMusicManager().currentMusic != null) {
                SoundInstance it2;
                boolean bl = false;
                ResourceLocation resourceLocation = it2.getSound().getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getLocation(...)");
                this$0.dispatchToast(resourceLocation);
                continue;
            }
            ToastComponent toastComponent = this$0.toastComponent;
            MutableComponent mutableComponent = Component.translatable((String)"gui.wailt.toast.no-song");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            toastComponent.addToast((Toast)new InfoToast((Component)mutableComponent));
        }
    }
}

