/*
 * Decompiled with CFR 0.152.
 */
package ifly.imperialroma.treetimber;

import com.mojang.logging.LogUtils;
import ifly.imperialroma.treetimber.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.slf4j.Logger;

@Mod(value="treetimber")
public class Treetimber {
    public static final String MODID = "treetimber";
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"treetimber");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"treetimber");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"treetimber");

    public Treetimber(FMLJavaModLoadingContext context) {
        BusGroup bus = context.getModBusGroup();
        BLOCKS.register(bus);
        ITEMS.register(bus);
        CREATIVE_MODE_TABS.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    public boolean isLog(BlockState blockState) {
        return ForgeRegistries.BLOCKS.getKey((Object)blockState.getBlock()).toString().endsWith("_log");
    }

    public boolean isAxe(ItemStack itemStack) {
        return ForgeRegistries.ITEMS.getKey((Object)itemStack.getItem()).toString().endsWith("_axe");
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer().isShiftKeyDown()) {
            return;
        }
        ItemStack itemStack = event.getPlayer().getMainHandItem();
        if (!this.isAxe(itemStack)) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState blockState = event.getState();
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> temp = new ArrayList<BlockPos>();
        if (this.isLog(blockState)) {
            blocks.add(pos);
            temp.add(pos);
            while (!temp.isEmpty()) {
                BlockPos pos1 = (BlockPos)temp.getFirst();
                for (Direction dir : Direction.values()) {
                    if (event.getLevel() == null) continue;
                    BlockPos blockPos = pos1.relative(dir);
                    if (!this.isLog(event.getLevel().getBlockState(blockPos)) || blocks.contains(blockPos)) continue;
                    blocks.add(blockPos);
                    temp.add(blockPos);
                }
                temp.removeFirst();
            }
            if (!this.isTree(blocks, (Level)event.getLevel())) {
                return;
            }
            for (BlockPos blockPos : blocks) {
                event.getPlayer().getMainHandItem().getItem().mineBlock(event.getPlayer().getMainHandItem(), (Level)event.getLevel(), event.getLevel().getBlockState(blockPos), blockPos, (LivingEntity)event.getPlayer());
                event.getLevel().destroyBlock(blockPos, true);
                if (!itemStack.isDamageableItem()) continue;
                itemStack.hurtAndBreak(1, (LivingEntity)event.getPlayer(), event.getPlayer().getEquipmentSlotForItem(itemStack));
            }
        }
    }

    public boolean isTree(List<BlockPos> blockPos, Level level) {
        BlockPos bs = blockPos.getFirst();
        if (bs != null) {
            int maxy = blockPos.stream().mapToInt(Vec3i::getY).max().getAsInt();
            BlockPos bs2 = new BlockPos(bs.getX(), maxy, bs.getZ());
            int count = 0;
            for (Direction direction : Direction.values()) {
                BlockState blockState = level.getBlockState(bs2.relative(direction));
                if (!ForgeRegistries.BLOCKS.getKey((Object)blockState.getBlock()).toString().endsWith("_leaves")) continue;
                ++count;
            }
            if (count >= 2) {
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="treetimber", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

