/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.api.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.samsthenerd.inline.api.data.SpriteInlineData;
import com.samsthenerd.inline.impl.InlineStyle;
import com.samsthenerd.inline.tooltips.CustomTooltipManager;
import com.samsthenerd.inline.tooltips.providers.ModDataTTProvider;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.utils.TextureSprite;
import com.samsthenerd.inline.utils.URLSprite;
import com.samsthenerd.inline.xplat.IModMeta;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;

public class ModIconData
extends SpriteInlineData {
    public static final Spritelike MISSING_ICON = new TextureSprite(new class_2960("inline", "textures/missingicon.png"));
    public String modid;

    @Override
    public ModIconDataType getType() {
        return ModIconDataType.INSTANCE;
    }

    @Override
    public class_2960 getRendererId() {
        return new class_2960("inline", "spritelike");
    }

    public ModIconData(String modid) {
        this(modid, true);
    }

    public ModIconData(String modid, boolean usePlaceholder) {
        super(ModIconData.spriteFromModid(modid, usePlaceholder));
        this.modid = modid;
    }

    @Nullable
    public static Spritelike spriteFromModid(String modid, boolean usePlaceholder) {
        Optional<IModMeta> maybeMod = IModMeta.getMod(modid);
        if (maybeMod.isEmpty()) {
            return usePlaceholder ? MISSING_ICON : null;
        }
        IModMeta mod = maybeMod.get();
        try {
            Optional<String> logoFile = mod.getLogoFile(128);
            if (logoFile.isEmpty()) {
                return usePlaceholder ? MISSING_ICON : null;
            }
            Optional<Path> logoPath = mod.findResource(logoFile.get());
            if (logoPath.isEmpty()) {
                return usePlaceholder ? MISSING_ICON : null;
            }
            return new URLSprite(logoPath.get().toUri().toURL().toString(), new class_2960("inlinemodicon", mod.getModId()));
        }
        catch (Exception e) {
            return usePlaceholder ? MISSING_ICON : null;
        }
    }

    public static class_2583 getTooltipStyle(String modid) {
        Optional<IModMeta> maybeMod = IModMeta.getMod(modid);
        if (maybeMod.isEmpty()) {
            return class_2583.field_24360;
        }
        IModMeta mod = maybeMod.get();
        class_2568 he = new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(CustomTooltipManager.getForTooltip(ModDataTTProvider.INSTANCE, mod)));
        class_2583 styled = class_2583.field_24360.method_10949(he);
        Optional<String> homepageMaybe = mod.getHomepage();
        if (homepageMaybe.isPresent()) {
            class_2558 ce = new class_2558(class_2558.class_2559.field_11749, homepageMaybe.get().toString());
            styled = styled.method_10958(ce);
        }
        return styled;
    }

    public static class_2561 makeModIcon(IModMeta mod) {
        class_2583 dataStyle = InlineStyle.fromInlineData(new ModIconData(mod.getModId()));
        return class_2561.method_43470((String)".").method_10862(dataStyle.method_27702(ModIconData.getTooltipStyle(mod.getModId())));
    }

    public static class ModIconDataType
    extends SpriteInlineData.SpriteDataType {
        public static ModIconDataType INSTANCE = new ModIconDataType();

        @Override
        public class_2960 getId() {
            return new class_2960("inline", "modicon");
        }

        @Override
        public Codec<SpriteInlineData> getCodec() {
            return Codec.STRING.flatComapMap(ModIconData::new, data -> {
                if (!(data instanceof ModIconData)) {
                    return DataResult.error(() -> "");
                }
                ModIconData mData = (ModIconData)data;
                return DataResult.success((Object)mData.modid);
            });
        }
    }
}

