/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.tooltips.providers;

import com.mojang.serialization.Codec;
import com.samsthenerd.inline.api.data.ModIconData;
import com.samsthenerd.inline.tooltips.CustomTooltipManager;
import com.samsthenerd.inline.tooltips.data.SpriteTooltipData;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.xplat.IModMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5632;
import org.jetbrains.annotations.NotNull;

public class ModDataTTProvider
implements CustomTooltipManager.CustomTooltipProvider<IModMeta> {
    public static final ModDataTTProvider INSTANCE = new ModDataTTProvider();

    @Override
    public class_2960 getId() {
        return new class_2960("inline", "moddata");
    }

    @Override
    @NotNull
    public List<class_2561> getTooltipText(IModMeta mod) {
        ArrayList<class_2561> modInfo = new ArrayList<class_2561>();
        if (mod == null) {
            return modInfo;
        }
        class_5250 title = class_2561.method_43470((String)mod.getName()).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        class_5250 description = class_2561.method_43470((String)mod.getDescription().replace("\n", "")).method_10862(class_2583.field_24360.method_10977(class_124.field_1080));
        modInfo.add((class_2561)title);
        modInfo.add((class_2561)description);
        return modInfo;
    }

    @Override
    @NotNull
    public Optional<class_5632> getTooltipData(IModMeta mod) {
        if (mod == null) {
            return Optional.empty();
        }
        Spritelike iconSprite = ModIconData.spriteFromModid(mod.getModId(), false);
        if (iconSprite == null) {
            return Optional.empty();
        }
        return Optional.of(new SpriteTooltipData(iconSprite, (w, h) -> 32));
    }

    @Override
    @NotNull
    public Codec<IModMeta> getCodec() {
        return Codec.STRING.xmap(modid -> IModMeta.getMod(modid).orElse(null), IModMeta::getModId);
    }
}

