/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.samsthenerd.inline.utils.SpriteUVRegion;
import com.samsthenerd.inline.utils.Spritelike;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class SpritelikeRenderers {
    private static final Map<Spritelike.SpritelikeType, SpritelikeRenderer> RENDERER_MAP = new HashMap<Spritelike.SpritelikeType, SpritelikeRenderer>();
    private static final SpritelikeRenderer DEFAULT_RENDERER = new SpritelikeRenderer();

    public static void registerRenderer(Spritelike.SpritelikeType type, SpritelikeRenderer renderer) {
        RENDERER_MAP.put(type, renderer);
    }

    public static SpritelikeRenderer getRenderer(Spritelike.SpritelikeType type) {
        if (RENDERER_MAP.containsKey(type)) {
            return RENDERER_MAP.get(type);
        }
        return DEFAULT_RENDERER;
    }

    public static SpritelikeRenderer getRenderer(Spritelike sprite) {
        return SpritelikeRenderers.getRenderer(sprite.getType());
    }

    public static class SpritelikeRenderer {
        public void drawSpriteWithLight(Spritelike sprite, class_332 ctx, float x, float y, float z, float width, float height, int light, int argb) {
            class_2960 texture = sprite.getTextureId();
            if (texture == null) {
                return;
            }
            RenderSystem.setShaderTexture((int)0, (class_2960)texture);
            RenderSystem.setShader(class_757::method_34508);
            Matrix4f matrix4f = ctx.method_51448().method_23760().method_23761();
            class_1921 renderLayer = class_1921.method_23580((class_2960)texture);
            class_4588 vc = ctx.method_51450().getBuffer(renderLayer);
            SpriteUVRegion uvs = sprite.getUVs();
            vc.method_22918(matrix4f, x, y, z).method_39415(argb).method_22913((float)uvs.minU(), (float)uvs.minV()).method_22922(class_4608.field_21444).method_22916(light).method_23763(ctx.method_51448().method_23760().method_23762(), 0.0f, 0.0f, 1.0f).method_1344();
            vc.method_22918(matrix4f, x, y + height, z).method_39415(argb).method_22913((float)uvs.minU(), (float)uvs.maxV()).method_22922(class_4608.field_21444).method_22916(light).method_23763(ctx.method_51448().method_23760().method_23762(), 0.0f, 0.0f, 1.0f).method_1344();
            vc.method_22918(matrix4f, x + width, y + height, z).method_39415(argb).method_22913((float)uvs.maxU(), (float)uvs.maxV()).method_22922(class_4608.field_21444).method_22916(light).method_23763(ctx.method_51448().method_23760().method_23762(), 0.0f, 0.0f, 1.0f).method_1344();
            vc.method_22918(matrix4f, x + width, y, z).method_39415(argb).method_22913((float)uvs.maxU(), (float)uvs.minV()).method_22922(class_4608.field_21444).method_22916(light).method_23763(ctx.method_51448().method_23760().method_23762(), 0.0f, 0.0f, 1.0f).method_1344();
            ctx.method_51450().method_22994(renderLayer);
        }

        public void drawSprite(Spritelike sprite, class_332 ctx, float x, float y, float z, float width, float height) {
            class_2960 texture = sprite.getTextureId();
            if (texture == null) {
                return;
            }
            RenderSystem.setShaderTexture((int)0, (class_2960)texture);
            RenderSystem.setShader(class_757::method_34542);
            Matrix4f matrix4f = ctx.method_51448().method_23760().method_23761();
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            SpriteUVRegion uvs = sprite.getUVs();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_22918(matrix4f, x, y, z).method_22913((float)uvs.minU(), (float)uvs.minV()).method_1344();
            bufferBuilder.method_22918(matrix4f, x, y + height, z).method_22913((float)uvs.minU(), (float)uvs.maxV()).method_1344();
            bufferBuilder.method_22918(matrix4f, x + width, y + height, z).method_22913((float)uvs.maxU(), (float)uvs.maxV()).method_1344();
            bufferBuilder.method_22918(matrix4f, x + width, y, z).method_22913((float)uvs.maxU(), (float)uvs.minV()).method_1344();
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        }
    }
}

