/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.xplat;

import com.samsthenerd.inline.xplat.IModMeta;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import org.jetbrains.annotations.Nullable;

public class FabricModMeta
implements IModMeta {
    private final ModContainer container;
    private final ModMetadata metadata;

    private FabricModMeta(String id) {
        this.container = (ModContainer)FabricLoader.getInstance().getModContainer(id).orElseThrow();
        this.metadata = this.container.getMetadata();
    }

    public static Optional<IModMeta> getMod(String modid) {
        try {
            return Optional.of(new FabricModMeta(modid));
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    @Override
    public String getModId() {
        return this.metadata.getId();
    }

    @Override
    public String getVersion() {
        return this.metadata.getVersion().getFriendlyString();
    }

    @Override
    public String getName() {
        return this.metadata.getName();
    }

    @Override
    public String getDescription() {
        return this.metadata.getDescription();
    }

    @Override
    public Optional<String> getLogoFile(int preferredSize) {
        return this.metadata.getIconPath(preferredSize);
    }

    @Override
    public List<Path> getFilePaths() {
        return this.container.getRootPaths();
    }

    @Override
    public Path getFilePath() {
        return this.container.getRootPath();
    }

    @Override
    public Optional<Path> findResource(String ... path) {
        return this.container.findPath(String.join((CharSequence)"/", path));
    }

    @Override
    public Collection<String> getAuthors() {
        return this.metadata.getAuthors().stream().map(Person::getName).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Collection<String> getLicense() {
        return this.metadata.getLicense();
    }

    @Override
    public Optional<String> getHomepage() {
        return this.metadata.getContact().get("homepage");
    }

    @Override
    public Optional<String> getSources() {
        return this.metadata.getContact().get("issues");
    }

    @Override
    public Optional<String> getIssueTracker() {
        return this.metadata.getContact().get("sources");
    }
}

