/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline;

import com.samsthenerd.inline.api.InlineAPI;
import com.samsthenerd.inline.api.data.EntityInlineData;
import com.samsthenerd.inline.api.data.ItemInlineData;
import com.samsthenerd.inline.api.data.ModIconData;
import com.samsthenerd.inline.api.data.PlayerHeadData;
import com.samsthenerd.inline.api.data.SpriteInlineData;
import com.samsthenerd.inline.api.matching.InlineMatch;
import com.samsthenerd.inline.api.matching.MatcherInfo;
import com.samsthenerd.inline.api.matching.RegexMatcher;
import com.samsthenerd.inline.xplat.XPlatInstances;
import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Inline {
    public static final String MOD_ID = "inline";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"inline");
    private static XPlatInstances xPlats;
    private static final Map<String, String> EQUIPMENT_ALIASES;

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static XPlatInstances getXPlats() {
        return xPlats;
    }

    public static final void logPrint(String message) {
        LOGGER.info(message);
    }

    public static void onInitialize(XPlatInstances xPlats) {
        Inline.xPlats = xPlats;
        Inline.registerDataTypes();
        Inline.addChatMatchers();
    }

    private static void registerDataTypes() {
        InlineAPI.INSTANCE.addDataType(EntityInlineData.EntityDataType.INSTANCE);
        InlineAPI.INSTANCE.addDataType(ItemInlineData.ItemDataType.INSTANCE);
        InlineAPI.INSTANCE.addDataType(ModIconData.ModIconDataType.INSTANCE);
        InlineAPI.INSTANCE.addDataType(PlayerHeadData.PlayerHeadDataType.INSTANCE);
        InlineAPI.INSTANCE.addDataType(SpriteInlineData.SpriteDataType.INSTANCE);
    }

    private static void addChatMatchers() {
        class_2960 showOffID = class_2960.method_60655((String)MOD_ID, (String)"showoff");
        RegexMatcher.ChatStandard showOffMatcher = new RegexMatcher.ChatStandard("show", RegexMatcher.Standard.IDENTIFIER_REGEX_INSENSITIVE, showOffID, (whatToShow, ctx) -> {
            class_1799 stack = null;
            whatToShow = EQUIPMENT_ALIASES.getOrDefault(whatToShow, (String)whatToShow);
            try {
                stack = ctx.getChatSender().method_6118(class_1304.method_5924((String)whatToShow));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stack == null || stack.method_7960()) {
                stack = new class_1799((class_1935)class_1802.field_8077);
                stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)"ui.inline.nothingtoshowoff"));
            }
            class_2568 he = new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(stack));
            return new InlineMatch.DataMatch(new ItemInlineData(stack), class_2583.field_24360.method_10949(he));
        }, MatcherInfo.fromId(showOffID));
        InlineAPI.INSTANCE.addChatMatcher(showOffMatcher);
    }

    static {
        EQUIPMENT_ALIASES = Map.of("hand", "mainhand", "chestplate", "chest", "leggings", "legs", "helmet", "head", "boots", "feet", "shoes", "feet");
    }
}

