/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.blaze3d.systems.RenderSystem;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineClientAPI;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.impl.InlineStyle;
import com.samsthenerd.inline.mixin.core.MixinSetTessBuffer;
import com.samsthenerd.inline.utils.ColorUtils;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.utils.SpritelikeRenderers;
import com.samsthenerd.inline.utils.TextureSprite;
import com.samsthenerd.inline.utils.VCPImmediateButImLyingAboutIt;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.time.Duration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2583;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_6367;
import net.minecraft.class_8251;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class InlineRenderCore {
    private static class_6367 GLOW_BUFF = new class_6367(128, 128, true, class_310.field_1703);
    private static Set<class_2960> ERRORED_RENDERERS = new HashSet<class_2960>();
    private static final Cache<String, Spritelike> GLOW_TEXTURE_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(Duration.ofMinutes(5L)).removalListener(notif -> {
        Object patt0$temp = notif.getValue();
        if (patt0$temp instanceof TextureSprite) {
            TextureSprite tSprite = (TextureSprite)patt0$temp;
            class_310.method_1551().method_1531().method_4615(tSprite.getTextureId());
        }
    }).build();
    private static final class_289 secondaryTess = new class_289();

    public static boolean textDrawerAcceptHandler(int index, class_2583 style, int codepoint, RenderArgs args) {
        class_4587 matrices;
        class_289 heldTess;
        InlineRenderer<?> renderer;
        InlineData inlData;
        block11: {
            int rendererARGB;
            boolean needToHandleSize;
            class_4597.class_4598 imm;
            inlData = style.getInlineData();
            if (inlData == null) {
                return false;
            }
            renderer = InlineClientAPI.INSTANCE.getRenderer(inlData.getRendererId());
            if (renderer == null) {
                return false;
            }
            boolean noGlowHandle = !(renderer.getGlowPreference(inlData) instanceof GlowHandling.None);
            boolean hasGlowyMarker = (Boolean)style.getComponent(InlineStyle.GLOWY_MARKER_COMP);
            if (noGlowHandle && hasGlowyMarker) {
                return true;
            }
            int glowColor = (Integer)style.getComponent(InlineStyle.GLOWY_PARENT_COMP);
            boolean needsGlowChildren = glowColor != -1 && renderer.getGlowPreference(inlData) instanceof GlowHandling.Full;
            heldTess = class_289.method_1348();
            MixinSetTessBuffer.setInstance(secondaryTess);
            class_4597 class_45972 = args.provider();
            class_4597.class_4598 immToUse = class_45972 instanceof class_4597.class_4598 ? (imm = (class_4597.class_4598)class_45972) : VCPImmediateButImLyingAboutIt.of(args.provider());
            immToUse.method_22993();
            class_332 drawContext = new class_332(class_310.method_1551(), immToUse);
            matrices = drawContext.method_51448();
            matrices.method_22903();
            double sizeMod = (Double)style.getComponent(InlineStyle.SIZE_MODIFIER_COMP);
            matrices.method_34425(args.matrix());
            matrices.method_34425(new Matrix4f().scale(1.0f, 1.0f, 0.001f));
            matrices.method_23760().method_23762().mul((Matrix3fc)new Matrix3f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f));
            matrices.method_23760().method_23762().scale(-1.0f);
            matrices.method_46416(args.x(), args.y(), 0.0f);
            double maxSizeMod = InlineClientAPI.INSTANCE.getConfig().maxChatSizeModifier();
            if (sizeMod > maxSizeMod && InlineRenderer.isFlat(matrices, args.layerType) && InlineRenderer.isChatty()) {
                sizeMod = maxSizeMod;
            }
            boolean bl = needToHandleSize = sizeMod != 1.0 && !renderer.handleOwnSizing(inlData);
            if (needToHandleSize) {
                double yOffset = (sizeMod - 1.0) * 4.0;
                matrices.method_22904(0.0, -yOffset, 0.0);
                matrices.method_22905((float)sizeMod, (float)sizeMod, 1.0f);
            }
            float alphaToUse = args.alpha() == 0.0f ? 1.0f : args.alpha();
            int usableColor = rendererARGB = class_5253.class_5254.method_27764((int)Math.round(alphaToUse * 255.0f), (int)Math.round(args.red() * 255.0f), (int)Math.round(args.green() * 255.0f), (int)Math.round(args.blue() * 255.0f));
            if (style.method_10973() != null) {
                usableColor = class_5253.class_5254.method_27763((int)rendererARGB, (int)(style.method_10973().method_27716() | 0xFF000000));
            }
            InlineRenderer.TextRenderingContext trContext = new InlineRenderer.TextRenderingContext(args.light(), args.shadow(), args.brightnessMultiplier(), args.red(), args.green(), args.blue(), args.alpha() == 0.0f ? 1.0f : args.alpha(), args.layerType(), args.provider(), (Boolean)style.getComponent(InlineStyle.GLOWY_MARKER_COMP), (Integer)style.getComponent(InlineStyle.GLOWY_PARENT_COMP), usableColor);
            if (!renderer.handleOwnTransparency(inlData)) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaToUse);
            }
            try {
                if (needsGlowChildren) {
                    class_3545<Spritelike, Runnable> texResult = InlineRenderCore.getGlowTextureSprite(inlData, renderer, immToUse, sizeMod, index, style, codepoint, trContext);
                    Spritelike backSprite = (Spritelike)texResult.method_15442();
                    int brighterGlow = ColorUtils.ARGBtoHSB(glowColor)[2] > ColorUtils.ARGBtoHSB(usableColor)[2] ? glowColor : usableColor;
                    SpritelikeRenderers.getRenderer(backSprite).drawSpriteWithLight(backSprite, drawContext, -2.0f, -4.0f, 0.0f, 16.0f, 16.0f, trContext.light(), brighterGlow);
                    ((Runnable)texResult.method_15441()).run();
                }
                matrices.method_46416(0.0f, 0.0f, 10.0f);
                args.xUpdater().addAndGet((double)((float)renderer.render(inlData, drawContext, index, style, codepoint, trContext) * (needToHandleSize ? (float)sizeMod : 1.0f)));
                immToUse.method_22993();
            }
            catch (Exception e) {
                if (!ERRORED_RENDERERS.add(inlData.getRendererId())) break block11;
                Inline.LOGGER.error("Error rendering inline with renderer: " + inlData.getRendererId().toString() + " -- To prevent logspam this will only show once. This is likely an issue with whatever mod adds the renderer.");
            }
        }
        if (!renderer.handleOwnTransparency(inlData)) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        matrices.method_22909();
        MixinSetTessBuffer.setInstance(heldTess);
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static class_3545<Spritelike, Runnable> getGlowTextureSprite(InlineData inlData, InlineRenderer renderer, class_4597.class_4598 immToUse, double sizeMod, int index, class_2583 style, int codepoint, InlineRenderer.TextRenderingContext trContext) {
        Spritelike texSpriteMaybe;
        double outlineScaleBack = 1.0 / sizeMod;
        boolean needToHandleSize = sizeMod != 1.0 && !renderer.handleOwnSizing(inlData);
        GlowHandling glowHandling = renderer.getGlowPreference(inlData);
        if (!(glowHandling instanceof GlowHandling.Full)) {
            return null;
        }
        GlowHandling.Full fullHandling = (GlowHandling.Full)glowHandling;
        String texCacheId = null;
        if (fullHandling.cacheId != null && (texSpriteMaybe = (Spritelike)GLOW_TEXTURE_CACHE.getIfPresent((Object)(texCacheId = "inlineglowtexture" + renderer.getId().method_42094() + "." + fullHandling.cacheId + sizeMod))) != null) {
            return new class_3545((Object)texSpriteMaybe, () -> {});
        }
        int resScale = 8;
        GLOW_BUFF.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        GLOW_BUFF.method_1230(false);
        class_310.method_1551().method_1522().method_1240();
        Matrix4fStack mvStack = RenderSystem.getModelViewStack();
        Matrix4f backupProjMatrix = RenderSystem.getProjectionMatrix();
        mvStack.pushMatrix();
        mvStack.identity();
        RenderSystem.applyModelViewMatrix();
        class_8251 backupVertexSorter = RenderSystem.getVertexSorting();
        RenderSystem.backupProjectionMatrix();
        Matrix4f newProjMatrix = new Matrix4f();
        newProjMatrix.identity();
        newProjMatrix.setOrtho(0.0f, (float)(16 * resScale), 0.0f, (float)(16 * resScale), 0.0f, 100.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)newProjMatrix, (class_8251)class_8251.field_43360);
        GLOW_BUFF.method_1235(true);
        class_332 glowContext = new class_332(class_310.method_1551(), immToUse);
        class_4587 glowStack = glowContext.method_51448();
        glowStack.method_22903();
        glowStack.method_46416((float)(2 * resScale), (float)(4 * resScale), -50.0f);
        glowStack.method_22905((float)resScale, (float)resScale, 1.0f);
        glowStack.method_34425(new Matrix4f().scale(1.0f, 1.0f, 0.01f));
        float xOffsetDiff = (float)renderer.render(inlData, glowContext, index, style, codepoint, trContext) * (needToHandleSize ? (float)sizeMod : 1.0f);
        immToUse.method_22993();
        mvStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)backupProjMatrix, (class_8251)backupVertexSorter);
        GLOW_BUFF.method_1240();
        try (class_1011 nativeImage = new class_1011(16 * resScale, 16 * resScale, true);){
            GLOW_BUFF.method_35610();
            nativeImage.method_4327(0, false);
            GLOW_BUFF.method_1242();
            class_1011 fullImage = new class_1011(nativeImage.method_4307(), nativeImage.method_4323(), true);
            int outlineRange = (int)Math.round((double)resScale * outlineScaleBack);
            LinkedList<Integer> pixelQueue = new LinkedList<Integer>();
            Int2IntOpenHashMap seenPixels = new Int2IntOpenHashMap();
            int imgWidth = nativeImage.method_4307();
            int imgHeight = nativeImage.method_4323();
            for (int px = 0; px < imgWidth; ++px) {
                for (int py = 0; py < imgHeight; ++py) {
                    if (class_5253.class_5254.method_27762((int)nativeImage.method_4315(px, py)) == 0) continue;
                    int thisPos = px + py * imgWidth;
                    seenPixels.put(thisPos, 0);
                    pixelQueue.add(thisPos);
                }
            }
            nativeImage.close();
            while (!pixelQueue.isEmpty()) {
                int cPix = (Integer)pixelQueue.poll();
                int cX = cPix % imgWidth;
                int cY = cPix / imgWidth;
                fullImage.method_4305(cX, cY, -1);
                if (seenPixels.get(cPix) >= outlineRange) continue;
                for (int i = -1; i <= 1; ++i) {
                    if (cX + i < 0 || cX + i >= imgWidth) continue;
                    for (int j = -1; j <= 1; ++j) {
                        int nbrPos;
                        if (cY + j < 0 || cY + j >= imgHeight || seenPixels.containsKey(nbrPos = cPix + i + j * imgWidth)) continue;
                        seenPixels.put(nbrPos, seenPixels.get(cPix) + 1);
                        pixelQueue.add(nbrPos);
                    }
                }
            }
            class_310.method_1551().method_1522().method_1235(true);
            if (texCacheId != null) {
                class_2960 backTexId = class_310.method_1551().method_1531().method_4617(texCacheId, new class_1043(fullImage));
                TextureSprite tSprite = new TextureSprite(backTexId);
                GLOW_TEXTURE_CACHE.put((Object)texCacheId, (Object)tSprite);
                class_3545 class_35452 = new class_3545((Object)tSprite, () -> {});
                return class_35452;
            }
            class_2960 backTexId = class_310.method_1551().method_1531().method_4617(Inline.id("glowtextureback").method_42094(), new class_1043(fullImage));
            class_3545 class_35453 = new class_3545((Object)new TextureSprite(backTexId), () -> class_310.method_1551().method_1531().method_4615(backTexId));
            return class_35453;
        }
        catch (Exception e) {
            Inline.LOGGER.error(e.toString());
            return null;
        }
    }

    public record RenderArgs(float x, float y, Matrix4f matrix, int light, boolean shadow, float brightnessMultiplier, float red, float green, float blue, float alpha, class_327.class_6415 layerType, class_4597 provider, AtomicDouble xUpdater) {
    }
}

