/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.util.Either;
import com.samsthenerd.inline.api.client.InlineClientAPI;
import com.samsthenerd.inline.api.client.InlineClientConfig;
import com.samsthenerd.inline.api.matching.InlineMatcher;
import com.samsthenerd.inline.api.matching.MatchContext;
import java.time.Duration;
import net.minecraft.class_2561;

public class MatchCacher {
    private static final LoadingCache<Either<String, class_2561>, MatchContext> MATCH_CACHE = CacheBuilder.newBuilder().maximumSize(250L).expireAfterAccess(Duration.ofMinutes(5L)).build(CacheLoader.from(input -> {
        MatchContext matchContext = (MatchContext)input.map(MatchContext::forInput, MatchContext::forTextInput);
        InlineClientConfig config = InlineClientAPI.INSTANCE.getConfig();
        for (InlineMatcher matcher : InlineClientAPI.INSTANCE.getAllMatchers()) {
            if (!config.isMatcherEnabled(matcher.getId())) continue;
            matcher.match(matchContext);
        }
        matchContext.freeze();
        return matchContext;
    }));

    public static MatchContext getMatch(Either<String, class_2561> input) {
        return (MatchContext)MATCH_CACHE.getUnchecked(input);
    }

    public static void clear() {
        MATCH_CACHE.invalidateAll();
    }
}

